#include "mbed.h"

// Labs 2: Example program for using an interrupt (or callback)
// -----------------------------------------------------------
// A callback function (corresponding to an ISR) is called when a button 
//    is pressed
// The callback uses a shared variable to signal another thread

InterruptIn button_G(PTD0);
InterruptIn button_B(PTD5);

DigitalOut led_G(LED_GREEN);
DigitalOut led_B(LED_BLUE);

volatile int pressEvent_G = 0 ;
volatile int pressEvent_B = 0 ;

// This function is invoked when then interrupt occurs
//   Signal that the button has been pressed
//   Note: bounce may occur 
void buttonCallback_G(){
    pressEvent_G = 1 ;
}

void buttonCallback_B(){
    pressEvent_B = 1 ;
}

/*  ---- Main function (default thread) ----
    Note that if this thread completes, nothing else works
 */
int main() {
    button_G.mode(PullUp);             // Ensure button i/p has pull up
    button_G.fall(&buttonCallback_G) ;   // Attach function to falling edge

    button_B.mode(PullUp);             // Ensure button i/p has pull up
    button_B.fall(&buttonCallback_B) ;   // Attach function to falling edge

    //int counter_G = 2;
    //int rate_G = 1;
    
    //int counter_B = 2;
    //int rate_B = 1;    
    
    bool on_G = 0;
    bool on_B = 0;

    while(true) {
        // Toggle the Green LED every time the button is pressed
        if (pressEvent_G) {
            //led_G = !led_G ;
            pressEvent_G = 0 ; // Clear the event variable
            on_G = !on_G;
        }
        
        // Toggle the Green LED every time the button is pressed
        if (pressEvent_B) {
            //led_B = !led_B ;
            pressEvent_B = 0 ; // Clear the event variable
            on_B = !on_B;
        }
        
        led_G = (!led_G)|on_G;
        led_B = (!led_B)|on_B;
        
        wait(0.5) ;
    }
}