#include "mbed.h"
#include "MMA8451Q.h"

                //  rgb (active low)
#define Red     (0b0011)
#define Green   (0b0101)
#define Blue    (0b0110)
#define Yellow  (0b0001)
#define Cyan    (0b0100)
#define Magenta (0b0010)
#define White   (0b0000)
#define Black   (0b0111)

#define Xp  Red 
#define Xn  Yellow 
#define Yp  Green 
#define Yn  Cyan 
#define Zp  Blue 
#define Zn  Magenta 
#define IN  Black

/*
assuming (x^2 + y^2 + z^2)^0.5 = 1 
    G-> shared between 2 axes = 0.707 value
    G-> shared between 3 axes = 0.577 value 
    Could make threshold for orientation to be 0.9 giving reasonable margin
*/
#define TH 0.9 //Threshold for deciding orientation

// IO declarations
#define MMA8451_I2C_ADDRESS (0x1d<<1)

PinName const SDA = PTE25;
PinName const SCL = PTE24;

DigitalOut rled(LED1);
DigitalOut gled(LED2);
DigitalOut bled(LED3);

MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
Serial pc(USBTX, USBRX); // tx, rx

int orientation_find(float x, float y, float z){
    if      (abs(x) > TH){
        if (x > 0){
           return(Xp);
        }
        else{
            return(Xn);
        }
    }
    else if (abs(y) > TH){
       if (y > 0){
           return(Yp);
        }
        else{
            return(Yn);
        }
    }
    else if (abs(z) > TH){
       if (z > 0){
           return(Zp);
        }
        else{
            return(Zn);
        }
    }    
    else {
        return(IN);
    }//end case 
}//end func

int main(void)
{
    int state = IN;
    int tick = 0;    
    int system = 1;

    //still needed:
    pc.printf("MMA8451 ID: %d\n\r", acc.getWhoAmI()); 
    
    //init leds
    rled = 1;
    gled = 1;
    bled = 1;

    while (true) {
        float x, y, z;
        x = acc.getAccX();
        y = acc.getAccY();
        z = acc.getAccZ();
        
        state = orientation_find(x,y,z);          
         
        switch(system){
            case 1: //initial flat state
                if(tick > 100 && state == Yn){
                    //pc.printf("passed first stage \n\r"); 
                    system = 2;
                    tick = 0;
                }
                else if( tick < 100 && state == Yn){
                    system = 6; 
                }
                else if(state != Zp && state != IN){
                    system = 5;
                }
            break;
            
            case 2: //right orientation state
                if(tick > 20 && tick < 60 && state == Xn){
                    //pc.printf("passed second stage \n\r");
                    system = 3;
                    tick = 0;
                }
                else if((tick > 20 && state == Xn) || tick > 60 ){
                    system = 6; 
                }
                else if(state != Yn && state != IN){
                    system = 5;
                }
            break;

            case 3: //upwards orientation
                if(tick > 40 && tick < 80 && state == Zp){
                    //pc.printf("passed third stage \n\r");
                    system = 4;
                    tick = 0;
                }
                else if((tick > 40 && state == Zp) || tick > 80 ){
                    system = 6; 
                }
                else if(state != Xn && state != IN){
                    system = 5;
                }
            break;
            
            case 4://flat success
                pc.printf("Sequence is complete\n\r");
                system = 7;
                gled = 0;
            break;
            
            case 5://sequence fail
                pc.printf("Sequence Error \n\r");
                system = 7;
                rled = 0;
            break;

            case 6://timing fail
                pc.printf("Time error \n\r");
                system = 7;
                rled = 0;
            break;
            
            case 7://idle state
                // nothing happens
            break;        
        
        }// end switch        
        wait(0.1); // 100ms timing accuracy, 
        tick++;
    }//end while
}//end main
