 /* mbed UniGraphic library - MINISTM32 protocol class
 * Copyright (c) 2015 Giuliano Dianda
 * Released under the MIT License: http://mbed.org/license/mit
 *
 * Derived work of:
 *
 * mbed library for 240*320 pixel display TFT based on ILI9341 LCD Controller
 * Copyright (c) 2013 Peter Drescher - DC2PD
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
 * IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
 * FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
 * AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
 * LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
 * OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
 * THE SOFTWARE.
 */
 #if DEVICE_PORTINOUT 
#include "MINISTM32.h"

MINISTM32::MINISTM32()
    : _HI(PortB, 0x0000FF00), _LO(PortC, 0x000000FF), _CS(PC_8), _DC(PC_9), _WR(PC_10), _RD(PC_11)
{
    _DC=1;
    _WR=1;
    _RD=1;
    _CS=1;
    // most interaction is output, so only change to input for reading
    _HI.output();
    _LO.output();
    
    hw_reset();    
}

void MINISTM32::wr_cmd8(unsigned char cmd)
{      
    _DC = 0; // 0=cmd
    GPIOC->BSRR = cmd | (~(cmd << 16) & 0x00FF0000) | (1 << 26);
    GPIOC->BSRR = 1 << 10;
    _DC = 1; // 1=data next
}
void MINISTM32::wr_data8(unsigned char data)
{
    GPIOC->BSRR = data | (~data << 16) | (1 << 26);
    GPIOC->BSRR = 1 << 10;
}
void MINISTM32::wr_cmd16(unsigned short cmd)
{    
    _DC = 0; // 0=cmd
    GPIOC->BSRR = cmd >> 8 | (~cmd << 8) | (1 << 26);
    GPIOC->BSRR = 1 << 10;
    GPIOC->BSRR = (cmd & 0xFF) | (~(cmd & 0xFF) << 8) | (1 << 26);
    GPIOC->BSRR = 1 << 10;
    _DC = 1; // 1=data next
}
void MINISTM32::wr_data16(unsigned short data)
{
    GPIOC->BSRR = data >> 8 | (~data << 8) | (1 << 26);
    GPIOC->BSRR = 1 << 10;
    GPIOC->BSRR = (data & 0xFF) | (~(data & 0xFF) << 8) | (1 << 26);
    GPIOC->BSRR = 1 << 10;
}
void MINISTM32::wr_gram(unsigned short data)
{
    GPIOC->BSRR = (data & 0xFF) | ((~data & 0xFF) << 16) | (1 << 26);
    GPIOB->BSRR = (data & 0xFF00) | ((~data & 0xFF00) << 16);
    GPIOC->BSRR = 1 << 10;
}
void MINISTM32::wr_gram(unsigned short data, unsigned int count)
{
    _LO.write(data);    // write 16bit
    _HI.write(data);    // write 16bit
    // let's try direct GPIO access
    // _WR is PC_10
     if(count > 10) {
         // Unroll part of the loop for speed
        while(count)
        {

            GPIOC->BSRR = 1 << 26;
            GPIOC->BSRR = 1 << 10;
            GPIOC->BSRR = 1 << 10; // Acts as a NOP - too fast for the controller otherwise
            GPIOC->BSRR = 1 << 26;
            GPIOC->BSRR = 1 << 10;
            GPIOC->BSRR = 1 << 10;
            GPIOC->BSRR = 1 << 26;
            GPIOC->BSRR = 1 << 10;
            GPIOC->BSRR = 1 << 10;
            GPIOC->BSRR = 1 << 26;
            GPIOC->BSRR = 1 << 10;
            GPIOC->BSRR = 1 << 10;
            GPIOC->BSRR = 1 << 26;
            GPIOC->BSRR = 1 << 10;
            GPIOC->BSRR = 1 << 10;
            GPIOC->BSRR = 1 << 26;
            GPIOC->BSRR = 1 << 10;
            GPIOC->BSRR = 1 << 10;
            GPIOC->BSRR = 1 << 26;
            GPIOC->BSRR = 1 << 10;
            GPIOC->BSRR = 1 << 10;
            GPIOC->BSRR = 1 << 26;
            GPIOC->BSRR = 1 << 10;
            GPIOC->BSRR = 1 << 10;
            GPIOC->BSRR = 1 << 26;
            GPIOC->BSRR = 1 << 10;
            GPIOC->BSRR = 1 << 10;
            GPIOC->BSRR = 1 << 26;
            GPIOC->BSRR = 1 << 10;
                    
            count-=10;
        }
    }

    while(count)
    {
        GPIOC->BSRR = 1 << 26;
        GPIOC->BSRR = 1 << 10;
        count--;
    }
}
void MINISTM32::wr_grambuf(unsigned short* data, unsigned int length)
{
    while(length)
    {
        GPIOC->BSRR = (*data & 0xFF) | ((~*data & 0xFF) << 16) | (1 << 26);
        GPIOB->BSRR = (*data & 0xFF00) | ((~*data & 0xFF00) << 16);
        GPIOC->BSRR = 1 << 10;

        data++;
        length--;
    }
}
unsigned short MINISTM32::rd_gram(bool convert)
{
    unsigned int r=0;
   _LO.input();
   _HI.input();

    // dummy read
    GPIOC->BSRR = 1 << 27;
    GPIOC->BSRR = 1 << 11;
  
    
    GPIOC->BSRR = 1 << 27;
    r |= _LO.read() | _HI.read();
    GPIOC->BSRR = 1 << 11;

    if(convert)
    {
        r <<= 8;
        GPIOC->BSRR = 1 << 27;
        r |= _HI.read()>>8; //MSB of port read is blue, LSB is red of next pixel
        GPIOC->BSRR = 1 << 11;
        // gram is 18bit/pixel, if you set 16bit/pixel (cmd 3A), during writing the 16bits are expanded to 18bit
        // during reading, you read the raw 18bit gram
        r = RGB24to16((r&0xFF0000)>>16, (r&0xFF00)>>8, r&0xFF);// 18bit pixel padded to 24bits, rrrrrr00_gggggg00_bbbbbb00, converted to 16bit
    }
    _LO.output();
    _HI.output();
    return (unsigned short)r;
}
unsigned int MINISTM32::rd_reg_data32(unsigned char reg)
{
    wr_cmd8(reg);
    unsigned int r=0;
  //  _DC = 1; // 1=data
   _LO.input();
   _HI.input();
   
    // dummy read
    GPIOC->BSRR = 1 << 27;
    GPIOC->BSRR = 1 << 11;
    
    GPIOC->BSRR = 1 << 27;
    r |= (_LO.read()&0xFF);
    r <<= 8;
    GPIOC->BSRR = 1 << 11;
    
    GPIOC->BSRR = 1 << 27;
    r |= (_LO.read()&0xFF);
    r <<= 8;
    GPIOC->BSRR = 1 << 11;
    
    GPIOC->BSRR = 1 << 27;
    r |= (_LO.read()&0xFF);
    r <<= 8;
    GPIOC->BSRR = 1 << 11;
    
    GPIOC->BSRR = 1 << 27;
    r |= (_LO.read()&0xFF);
    GPIOC->BSRR = 1 << 11;
    
    _CS = 1; // toggle CS to interupt the cmd in case was not supported
    _CS = 0;

    _LO.output();
    _HI.output();
    return r;
}
// in Par mode EXTC regs (0xB0-0xFF) can be directly read
unsigned int MINISTM32::rd_extcreg_data32(unsigned char reg, unsigned char SPIreadenablecmd)
{
    return rd_reg_data32(reg);
}
// ILI932x specific
void MINISTM32::dummyread()
{
    _LO.input();
    _HI.input();
    // dummy read
    GPIOC->BSRR = 1 << 27;
    GPIOC->BSRR = 1 << 11;
    _LO.output();
    _HI.output();
}
// ILI932x specific
void MINISTM32::reg_select(unsigned char reg, bool forread)
{    
    _DC = 0;

    //uint32_t r = reg;

    GPIOC->BSRR = reg | (~(reg  << 16) & 0x00FF0000) | (1 << 26);
    GPIOC->BSRR = 1 << 10;
    GPIOC->BSRR = 1 << 10;
    _DC = 1; // 1=data next
}
// ILI932x specific
void MINISTM32::reg_write(unsigned char reg, unsigned short data)
{
    _DC = 0;
    GPIOC->BSRR = reg | (~(reg  << 16) & 0x00FF0000) | (1 << 26);
    GPIOB->BSRR = 0xFF000000;
    GPIOC->BSRR = 1 << 10;
    
    _DC = 1;
    GPIOC->BSRR = (data & 0xFF) | (~(data  << 16) & 0x00FF0000) | (1 << 26);
    GPIOB->BSRR = (data & 0xFF00) | (~(data  << 16) & 0xFF000000);
    GPIOC->BSRR = 1 << 10;
}
// ILI932x specific
unsigned short MINISTM32::reg_read(unsigned char reg)
{
    unsigned short r=0;
    _DC = 0;
    GPIOC->BSRR = reg | (~(reg  << 16) & 0x00FF0000) | (1 << 26);
    GPIOB->BSRR = 0xFF000000;
    GPIOC->BSRR = 1 << 10;

    _DC = 1;
    _LO.input();
    _HI.input();
    GPIOC->BSRR = 1 << 27;
    r |= _LO.read() | _HI.read();    // read 16bit
    GPIOC->BSRR = 1 << 11;
    _LO.output();
    _HI.output();
    return r;
}
void MINISTM32::hw_reset()
{
    ThisThread::sleep_for(15ms);
    _DC = 1;
    _CS = 1;
    _WR = 1;
    _RD = 1;
    ThisThread::sleep_for(100ms);
}
void MINISTM32::BusEnable(bool enable)
{
    _CS = enable ? 0:1;
}

#endif