#include "main.h"

#include "FastFontRenderer.h"
#include "FFArial24x23.h"
#include "FFTerminal6x8.h"

#include "resources/radiator_64x64_on_bmp.h"

unsigned short backgroundcolor=Black;
unsigned short foregroundcolor=White;

TouchScreen* touchScreen;
TouchScreenEventSource* eventSource;
EventDispatcher* eventDispatcher;
TextWidget* widget1;
TextWidget* widget2;
TextWidget* widget3;
BitmapWidget* bm1;
ContainerWidget* cw1;
GUI* gui;
GraphicsContext* context;
FastFontRenderer* fontRenderer;
FastFont* defaultFont;

Window* rootWindow;
Window* win1;
ILI932x* tft;

Serial *pc;

volatile bool done;
volatile int xt, yt;
volatile int xmin = 9999;
volatile int xmax = 0;
volatile int ymin = 9999;
volatile int ymax = 0;
    

void touchStart(TouchPosition p) {
   eventSource->touchStartHandler(p);
}
    
void touchMove(TouchPosition p) {
   eventSource->touchMoveHandler(p);
}
    
void touchEnd(TouchPosition p) {
   eventSource->touchEndHandler(p);
}

void tapHandler1(Event e) {
    TextWidget* w = (TextWidget*) e.target;
    if(done) {
        w->setBackground(Green);
    } else {
        w->setBackground(Blue);
    }
    done = !done;
  //  w->draw();    
}
void tapHandler2(Event e) {
    TextWidget* w = (TextWidget*) e.target;
    if(done) {
        w->setBackground(Green);
    } else {
        w->setBackground(Red);
    }
    done = !done;
   // w->draw();    
}

void dragHandler(Event e) {
    Widget* w = (Widget*) e.target;
    w->clear();
    w->setLocation(w->x(), e.screenY - w->height()/2);
   // w->draw();    
}

void initSerial() {
    pc = new Serial(USBTX, USBRX);
    pc->baud (9600);
    pc->printf("\n\nSystem Core Clock = %.3f MHZ\r\n",(float)SystemCoreClock/1000000);
}

void initGui() {
    
    tft = new ILI932x(PAR_8, PortC, LCD_CS, LCD_RESET, LCD_RS, LCD_WR, LCD_RD,"myLCD");
    tft->set_orientation(0);
    tft->cls();                // clear the screen
    tft->locate(0,0);
    tft->setBackground(backgroundcolor);    // set background to black
    tft->setForeground(foregroundcolor);    // set chars to white
    tft->set_font((unsigned char*) Arial24x23);
    eventDispatcher = new EventDispatcher();
    fontRenderer = new FastFontRenderer();
    defaultFont = new FastFont((uint8_t*)FFArial24x23);
    context = new GraphicsContext(tft, eventDispatcher, fontRenderer, defaultFont);
    gui = new GUI(context);
    rootWindow = gui->rootWindow();
}

void initTouchScreen() {
    touchScreen = new TouchScreen(T_DIN, T_DOUT, T_CLK, T_CS, T_IRQ);
    touchScreen->setTouchStartHandler(&touchStart);
    touchScreen->setTouchMoveHandler(&touchMove);
    touchScreen->setTouchEndHandler(&touchEnd);
    touchScreen->setLCDGeometry(LCD_X_RES, LCD_Y_RES, TOUCHSCREEN_ORIENTATION_PORTRAIT | TOUCHSCREEN_ORIENTATION_ROTATED);
    touchScreen->setCalibration(TOUCH_X_MIN, TOUCH_X_MAX, TOUCH_Y_MIN, TOUCH_Y_MAX);
    eventSource = new TouchScreenEventSource(touchScreen, gui);
}

int main()
{

    initSerial();
    initGui();
    initTouchScreen();
 
    
    cw1 = new ContainerWidget(context);
    cw1->setLocation(50,150);
    cw1->setSize(20,20);
    cw1->setBorder(4, Green);
    rootWindow->attach(cw1);
    {
     
        widget1 = new TextWidget(context);
        widget1->setSize(100,60);
        widget1->setText("This widget will change\ncolour when tapped");
        widget1->setBorder(1,White);
        cw1->attach(widget1);
        widget1->setEventHandler(new EventHandler(TOUCH_TAP, &tapHandler1));
        
        
        bm1 = new BitmapWidget(context);
        bm1->setBitmap(radiator_64x64_on_bmp, 64, 64);
        cw1->attach(bm1);
    }

    Widget *w = new Widget(context);
    w->setSize(60,60);
    w->setLocation(100,100);
    w->setBorder(2, Red);
    rootWindow->attach(w);

    widget2 = new TextWidget(context);
    widget2->setLocation(10,80);
    widget2->setSize(200,60);
    widget2->setText("A double-tap will make this\nwidget change colour");
    rootWindow->attach(widget2);
    widget2->setEventHandler(new EventHandler(TOUCH_DOUBLE_TAP, &tapHandler2));
 
    char *moveme = "ABCDEF\nGHIJKL\nMNOPQRS\nTUVWXYZ";
    widget3 = new TextWidget(context);
    widget3->setLocation(10,10);
    widget3->setSize(200,60);
    widget3->setText(moveme);
    rootWindow->attach(widget3);
    widget3->setEventHandler(new EventHandler(TOUCH_MOVE, &dragHandler));

 
    SpinnerWidget *sw = new SpinnerWidget(context);
    sw->setLocation(50,250);
    sw->setSize(128,96);
    sw->setIncrement(0.5);
    sw->setMax(20);
    sw->setMin(10);
    char *format = "%2.1f C";
    sw->setFormat(format);
    sw->setValue(9.5);
    rootWindow->attach(sw);

    while (1) {
        gui->updateWindow();
        gui->pumpEvents();
        Thread::wait(1);
    }
}
