#ifndef SIMPLEGUI_TOUCH_SCREEN_TOUCH_SCREEN_EVENT_SOURCE_H
#define SIMPLEGUI_TOUCH_SCREEN_TOUCH_SCREEN_EVENT_SOURCE_H

#include "SimpleGUI.h"
#include "TouchScreen.h"

/**
* If the time between a touchStart and touchEnd is less than this value, issue a tap event
**/
#define TAP_TIMEOUT_MICROS 150000
/**
* If two taps in succession were detected within this time, issue a double-tap event
**/
#define DOUBLE_TAP_TIMEOUT_MICROS 250000

// This class takes raw touch screen eents and turns them into events suitable for dispatch
// by the SimpleGUI EventDispatcher

class TouchScreenEventSource : public EventSource
{

public:
    TouchScreenEventSource(TouchScreen* touchScreen, EventDispatcher* dispatcher);

    void touchStartHandler(TouchPosition p);
    void touchMoveHandler(TouchPosition p);
    void touchEndHandler(TouchPosition p);

private:
    TouchScreen* _touchScreen;
    Timeout _timeout;

    enum State {
        Idle,
        SingleTimer,
        DoubleTimer
    };

    volatile State _state;

    void _timeoutHandler();
};

#endif