#ifndef SIMPLEGUI_UNIGRAPHIC_FONT_H
#define SIMPLEGUI_UNIGRAPHIC_FONT_H

#include "Font.h"

// Offset to the first glyph data
#define UNIGRAPHIC_FONT_DATA_OFFSET 4

/**
* A Font implementation based on the bitmap format used by the Unigraphic library
**/
class UGFont : public Font
{

public:

    UGFont(uint8_t* font, const uint8_t firstAsciiCode=32, const uint8_t lastAsciiCode=127, const bool proportional = true);

    virtual uint8_t firstAscii();
    virtual uint8_t lastAscii();
    virtual uint8_t widthOf(char c);
    virtual uint8_t zoomedWidthOf(char c);
    virtual uint8_t height();
    virtual uint8_t zoomedHeight();
    virtual bool isProportional();
    
    /**
    * Return the data part of the glyph - excluding the widht byte
    **/
    uint8_t* getGlyphData(char c);
    uint8_t bytesPerCol();
    uint8_t bytesPerGlyph();
    
private:

    uint8_t* _font;
    uint8_t _width, _height, _bytesPerCol, _bytesPerGlyph;
    uint8_t _firstAscii, _lastAscii, _proportional;

};
#endif