#ifndef SIMPLEGUI_FONT_RENDERER_H
#define SIMPLEGUI_FONT_RENDERER_H

#include "Font.h"
#include "GraphicsDisplay.h"
/**
* Abstract base class defining the interface for class which can render fonts to a GraphicsDisplay
* Should probably use some template wizardy to specify the covariant Font type....
**/
class FontRenderer {
public:

    FontRenderer() : _foreground(0xffff), _background(0)
    
    {
        window(0,0,0,0,true);
    }
    // You need to implement this..
    //virtual void setFont(Font* font) =0;
    
    /**
    * Render a single character at the current cursor location, advance the cursor
    * Clip/wrap as necessary
    **/
    virtual void putc(const char  c, GraphicsDisplay* display, Font* font) =0;
    /**
    * Render a string at the current cursor location, advance the cursor
    * Clip/wrap as necessary
    **/
    virtual void puts(const char* s, GraphicsDisplay* display, Font* font) =0;

    void setForeground(uint16_t foreground) {
        _foreground = foreground;
    }
    
    void setBackground(uint16_t background) {
        _background = background;
    }
    
    /**
    * Sets the window into which to render. placing the cursor at (x,y)
    **/
    void window(int x, int y, int width, int height, bool clip) {
        _wx0 = x;
        _wy0 = y;
        _wx1 = x + width;
        _wy1 = y + height;
        
        if(_wx0 > _wx1) {
            int tmp = _wx0;
            _wx0 = _wx1;
            _wx1 = tmp;
        }
        
        if(_wy0 > _wy1) {
            int tmp = _wy0;
            _wy0 = _wy1;
            _wy1 = tmp;
        }
        
        _cx = _wx0;
        _cy = _wy0;
        _clip = clip;
    }
        
protected:
    uint16_t _foreground, _background;
    int _wx0, _wx1, _wy0, _wy1, _cx, _cy;
    bool _clip;
};

#endif