#ifndef SIMPLEGUI_FONT_H
#define SIMPLEGUI_FONT_H

#include "mbed.h"

/**
* Interface defining a Font
* This is used by both the UniGraphic and FastFont implementations.
* 
**/
class Font
{
public:

    Font() : _zoomX(1), _zoomY(1) {};
    
    virtual uint8_t firstAscii() = 0;
    virtual uint8_t lastAscii() = 0;
    
    /**
    * The unzoomed width of the character
    **/
    virtual uint8_t  widthOf(char c) = 0;
    virtual uint8_t zoomedWidthOf(char c) =0;
    
    /**
    * The unzoomed height of a character
    **/
    virtual uint8_t  height() =0;
    virtual uint8_t zoomedHeight() =0;
    
    virtual bool isProportional() =0;
    
    bool contains(char c) {
        return c>= firstAscii() && c <= lastAscii();
    }
    
    void setZoom(uint8_t xmul, uint8_t ymul) {
        _zoomX=((xmul==0) ? 1:xmul);
        _zoomY=((ymul==0) ? 1:ymul);
    }

    uint8_t zoomX() {
        return _zoomX;
    }

    uint8_t zoomY() {
        return _zoomY;
    }

protected:

    uint8_t _zoomX, _zoomY;
};

#endif