#ifndef SIMPLEGUI_FAST_FONT_H
#define SIMPLEGUI_FAST_FONT_H

#include "mbed.h" // types
#include "Font.h"

#define FAST_FONT_HEIGHT 0
#define FAST_FONT_DATA_BYTES_PER_GLYPH 1
#define FAST_FONT_FIRST_ASCII 2
#define FAST_FONT_LAST_ASCII 3
#define FAST_FONT_PROPORTIONAL 4
#define FAST_FONT_DATA 5

class FastFont : public Font
{

public:

    FastFont(uint8_t* fastFont);

    virtual uint8_t firstAscii();
    virtual uint8_t lastAscii();
    /**
    * The unzoomed width of the character
    **/
    virtual uint8_t  widthOf(char c);
    virtual uint8_t zoomedWidthOf(char c);
    /**
    * The unzoomed height of a character
    **/
    virtual uint8_t  height();
    virtual uint8_t zoomedHeight();
    virtual bool isProportional();

    /*********************************
    * Methods specific to this class
    *********************************/
    uint8_t totalBytesPerGlyph();
    uint8_t dataBytesPerGlyph();
    uint8_t bytesPerRow();
    uint8_t* glyph(char c);


private:

    uint8_t* _font;
    uint8_t _totalBytesPerGlyph;
    uint8_t _bytesPerRow;
};


#endif