#ifndef SIMPLEGUI_EVENT_DISPATCHER_H
#define SIMPLEGUI_EVENT_DISPATCHER_H

#include "rtos.h"

#include "EventListener.h"
#include "LinkedList.h"

class EventDispatcher
{


public:

    EventDispatcher();

    void attachListener(EventListener* l);
    void detachListener(EventListener* l);
    void dispatchEvent(Event e);
    
    /**
    * Normally called from a separate thread to queue an event for later processing by the main thread
    **/
    void queueEvent(const Event e);
    
    /**
    * Should be called on the main thread
    **/
    void pumpEvents();

private:

    LinkedList<EventListener> _listeners;
    Mail<Event, 64> _mailbox;

};

#endif