#ifndef SIMPLEGUI_LINKED_LIST_H
#define SIMPLEGUI_LINKED_LIST_H

#include "mbed.h"

template<class T>
class LinkedListNode
{

public:

    LinkedListNode(T* nodeData) : data(nodeData), next(NULL) {}
    ~LinkedListNode() {}

    T* data;
    LinkedListNode<T>* next;
};

template<class T>
class LinkedListIterator {
    public:
    LinkedListIterator(LinkedListNode<T> *first) {
        _current = first;
    }
    
    ~LinkedListIterator() {}
    
    T* next() {

        LinkedListNode<T>* p = _current;
        if(p != NULL) {
            _current = _current->next;
            return p->data;
        }

        return NULL;
    }
    
private:
    LinkedListNode<T>* _current;
};

template<class T>
class LinkedList
{

public:

    LinkedList() : _first(NULL), _next(NULL), _current(NULL), _size(0) {}
    ~LinkedList() {}
    
    LinkedListIterator<T> getIterator() {
        LinkedListIterator<T> iterator(_first);
        return iterator;
    }

    void append(T* data) {

        if(_first == NULL) {

            _first = new LinkedListNode<T>(data);

        } else {

            LinkedListNode<T>* p = _first;
            LinkedListNode<T>* d = new LinkedListNode<T>(data);

            while(p->next != NULL) {
                p = p->next;
            }

            p->next = d;
        }
        _size++;
    }

    void appendOnce(T* data) {

        if(_first == NULL) {

            _first = new LinkedListNode<T>(data);
            _size++;

        } else {

            LinkedListNode<T>* p = _first;
            LinkedListNode<T>* d = new LinkedListNode<T>(data);

            while(p->next != NULL) {
                
                if(p->data == data) {
                    return;
                }
                
                p = p->next;
            }

            p->next = d;
            _size++;
        }
    }
    void remove(T* data) {

        if(_first == NULL) {
            return;
        }

        LinkedListNode<T>* next = _first;
        LinkedListNode<T>* prev = _first;

        if(_first->data == data) {
            _first = _first->next;
            delete next;
            _size--;
        } else {
            next = _first->next;
            while(next) {
                if(next->data == data) {
                    prev->next = next->next;
                    delete next;
                    _size--;
                    return;
                }
                prev = next;
                next = next->next;
            }
        }
    }
    
    void clear() {
        LinkedListNode<T>* here = _first;
        LinkedListNode<T>* next;
        while(here != NULL) {
            next = here->next;
            delete here;
            here = next;
        }
        _first = NULL;
        _size = 0;
    }

    void reset() {
        _current = _first;
    }

    T* next() {

        LinkedListNode<T>* p = _current;
        if(p != NULL) {
            _current = _current->next;
            return p->data;
        }

        return NULL;
    }
    
    bool contains(T *thing) {
        LinkedListNode<T>* here = _first;
        while(here != NULL) {
            if(here->data == thing) {
                return true;
            }
            here = here->next;
        }
        return false;
    }
    
    int size() {
        return _size;
    }


protected:

    LinkedListNode<T>* _first;
    LinkedListNode<T>* _next;
    LinkedListNode<T>* _current;
    int _size;

};

#endif