#ifndef SIMPLEGUI_CONTAINER_WIDGET_H
#define SIMPLEGUI_CONTAINER_WIDGET_H

#include "Widget.h"
#include "Window.h"

/**
* Simple container hold widgets side-by-side and draws a border
* It will expand as needed to hold the widgets
**/
class ContainerWidget : public Window
{

public:

    enum Layout { VERTICAL_LEFT, VERTICAL_RIGHT, VERTICAL_CENTER, HORIZONTAL, FIXED };

    ContainerWidget(GraphicsContext *context);
    
    /**
    * Overrides
    **/
    virtual void setSize(int width, int height);
    virtual void attach(Widget *child);

    void setLayout(Layout l);
    
protected:

    int _minWidth, _minHeight;
    Layout _layout;
    
    /**
    * Override
    **/
    virtual void _adjust();

};

#endif