#include "BitmapWidget.h"

BitmapWidget::BitmapWidget(GraphicsContext *context) : 
Widget(context), _monochrome(false), _bitmapWidth(0), _bitmapHeight(0)
{
}

BitmapWidget::BitmapWidget(GraphicsContext *context, bool monochrome) : 
Widget(context), _monochrome(monochrome), _bitmapWidth(0), _bitmapHeight(0)
{
}

void BitmapWidget::setMonochrome(bool enabled)
{
    _monochrome = enabled;
    dirty();
}

bool BitmapWidget::isMonochrome()
{
    return _monochrome;
}


void BitmapWidget::setBitmap(unsigned char const * bitmap, int width, int height)
{
    _bitmap = (unsigned char*)bitmap;
    _bitmapWidth = width;
    _bitmapHeight = height;
    // Adjust overall size so that the inner window fits the bitmap
    // Really we should just clip, but that's too hard for now
    setSize(((_padding + _borderWidth) * 2) + _bitmapWidth, ((_padding + _borderWidth) * 2) + _bitmapHeight);
    dirty();
}

void BitmapWidget::setBorder(int width, uint16_t color)
{
    Widget::setBorder(width, color);
    setSize(((_padding + _borderWidth) * 2) + _bitmapWidth, ((_padding + _borderWidth) * 2) + _bitmapHeight);
    dirty();
}

void BitmapWidget::_draw()
{
    Widget::_draw();
    
    if(_monochrome) {
        int fg = display()->getForeground();
        int bg = display()->getBackground();
        display()->setForeground(_fg);
        display()->setBackground(_bg);

        display()->Bitmap_FG_BG(_inner.x, _inner.y, _inner.width, _inner.height, _bitmap);

        display()->setForeground(fg);
        display()->setBackground(bg);
    } else {
        display()->Bitmap(_inner.x, _inner.y, _inner.width, _inner.height, _bitmap);
    }
}