#include "UGFont.h"

UGFont::UGFont(uint8_t* font, const uint8_t firstAsciiCode, const uint8_t lastAsciiCode, const bool proportional)
    : Font(), _font(&font[UNIGRAPHIC_FONT_DATA_OFFSET]), _firstAscii(firstAsciiCode), _lastAscii(lastAsciiCode), _proportional(proportional)
{
    // read font parameter from start of array in format understood by UniGraphics.
    // font[0] and font[3] are unused.
    // Data starts at font[4]
    // Data is laid out in column-order
    _width = font[1];
    _height = font[2];
    _bytesPerCol = (_height + 7) >> 3; // bytes per column
    _bytesPerGlyph = 1 + (_width * _bytesPerCol); // 1 byte for the width + actual data
}

uint8_t UGFont::firstAscii()
{
    return _firstAscii;
}

uint8_t UGFont::lastAscii()
{
    return _lastAscii;
}

uint8_t UGFont::widthOf(char c)
{

    if(c < _firstAscii || c > _lastAscii) {
        return 0;
    }

    return _font[((c - _firstAscii) * _bytesPerGlyph)];
}

uint8_t UGFont::zoomedWidthOf(char c)
{

    if(!_proportional) {
        return _width * _zoomX;
    }

    return widthOf(c) * _zoomX;
}

uint8_t UGFont::height()
{
    return _height;
}

uint8_t UGFont::zoomedHeight()
{
    return _zoomY * _height;
}

bool UGFont::isProportional() {
    return _proportional;
}

uint8_t* UGFont::getGlyphData(char c)
{
    if(c < _firstAscii || c > _lastAscii) {
        return NULL;
    }
    return &_font[((c - _firstAscii) * _bytesPerGlyph) + 1];
}

uint8_t UGFont::bytesPerCol()
{
    return _bytesPerCol;
}

uint8_t UGFont::bytesPerGlyph()
{
    return _bytesPerGlyph;
}
