
#include "FastFont.h"

FastFont::FastFont(uint8_t* fastFont)
    : _font(fastFont)
{
    _totalBytesPerGlyph = dataBytesPerGlyph() + 1;
    _bytesPerRow = dataBytesPerGlyph() / height();
}

/***************************************
* Implementation of the Font interface
***************************************/
uint8_t FastFont::firstAscii()
{
    return _font[FAST_FONT_FIRST_ASCII];
}

uint8_t FastFont::lastAscii()
{
    return _font[FAST_FONT_LAST_ASCII];
}

/**
* The unzoomed width of the character. Includes a following pixel
**/
 uint8_t  FastFont::widthOf(char c)
{
    if(c < _font[FAST_FONT_FIRST_ASCII] || c > _font[FAST_FONT_LAST_ASCII]) {
        return 0;
    }

    return _font[FAST_FONT_DATA + ((c - _font[FAST_FONT_FIRST_ASCII]) * _totalBytesPerGlyph)];
}

uint8_t FastFont::zoomedWidthOf(char c) {
    return (widthOf(c) * _zoomX);
}

/**
* The unzoomed height of a character
**/
 uint8_t  FastFont::height()
{
    return _font[FAST_FONT_HEIGHT];
}

 uint8_t FastFont::zoomedHeight()
{
    return _zoomY * _font[FAST_FONT_HEIGHT];
}

 bool FastFont::isProportional()
{
    return _font[FAST_FONT_PROPORTIONAL];
}


/***************************************
* Custom methods for this class
***************************************/

uint8_t FastFont::totalBytesPerGlyph()
{
    return _totalBytesPerGlyph;
}


uint8_t FastFont::dataBytesPerGlyph()
{
    return _font[FAST_FONT_DATA_BYTES_PER_GLYPH];
}

uint8_t FastFont::bytesPerRow()
{
    return _bytesPerRow;
}

uint8_t* FastFont::glyph(char c)
{
    if(c < _font[FAST_FONT_FIRST_ASCII] || c > _font[FAST_FONT_LAST_ASCII]) {
        return 0;
    }
    
    return _font + FAST_FONT_DATA + ((c - _font[FAST_FONT_FIRST_ASCII]) * _totalBytesPerGlyph) + 1;
}
