#ifndef SIMPLEGUI_GRAPHICSCONTEXT_H
#define SIMPLEGUI_GRAPHICSCONTEXT_H

#include "GraphicsDisplay.h"
#include "Events/EventDispatcher.h"
#include "Font/Font.h"
#include "Font/FontRenderer.h"

/**
* The GraphicsContext holds the core class needed to handle drawing and events
**/
class GraphicsContext
{

public:

    GraphicsContext(GraphicsDisplay* display, EventDispatcher* dispatcher, FontRenderer* fontRenderer, Font* defaultFont);

    GraphicsDisplay* display();
    EventDispatcher* eventDispatcher();
    FontRenderer* fontRenderer();
    Font* defaultFont();

private:
    GraphicsDisplay* _display;
    EventDispatcher* _dispatcher;
    FontRenderer* _renderer;
    Font* _font;
};

#endif