#include "mbed.h"
#include "FileIni.h"

#ifndef _POSIX_VERSION

int _strupr(char* ptrSource)
{
    int i=0;
    while(ptrSource[i]!='\0')
    {
        if (ptrSource[i]>='a' && ptrSource[i]<='z') ptrSource[i]=ptrSource[i]-48;
        i++;
    }
    return 0;
}
#endif


LPINI IniLoad(char* ptrFileName)
{
    /** declaration des variables */
    FILE* ptrFile=NULL;
    INI *lpinStart=NULL, *lpinCurrent=NULL, *lpinTmp=NULL;
    INIKEY *lpikKey=NULL, *lpikTmp=NULL;
    char ligne[MAX_PATH];
    char isSectionNew=2;
    char *ptrToken=NULL, *ptrLine=NULL;
    /** initialisation */
    lpinStart=(LPINI)malloc(sizeof(INI));
    if (lpinStart==NULL) return NULL;
    INI_ZERO(lpinStart);
    if (ptrFileName==NULL) return lpinStart;
    ptrFile=fopen(ptrFileName, "r");
    if (ptrFile==NULL) return NULL;
    lpinCurrent=lpinStart;
    /** parsage */
    wait(1);
    while (fgets(ligne, MAX_PATH, ptrFile)!=NULL)
    {
        /* on nettoie la ligne */
        if ((ptrToken=strchr(ligne, 13))) *ptrToken='\0';
        /* on supprime les commentaires */
        if ((ptrToken=strchr(ligne, ';'))) *ptrToken='\0';
        wait(0.5);
        if (*ligne=='[')
        {
            ptrLine=ligne+1;
            ptrToken=strchr(ptrLine, ']');
            if (ptrToken!=NULL) *ptrToken='\0';
            _strupr(ptrLine);
            /** On alloue une nouvelle structure */
            if (!(lpinTmp=(LPINI)malloc(sizeof(INI)))) EXIT_FREE
            INI_ZERO(lpinTmp);
            lpinCurrent->lpinNext=lpinTmp;
            lpinCurrent=lpinTmp;
            if (!(lpinCurrent->ptrSectionName=(char*)malloc(strlen(ptrLine)+1))) EXIT_FREE
            _strupr(ptrLine);
            strcpy(lpinCurrent->ptrSectionName, ptrLine);
            isSectionNew=1;
            /* il s'agit d'une Nouvelle Section */
        }
        else if (*ligne!='\0')
        {
            /*  il s'agit d'une cl&#65533;&#65533; */
            if (ptrToken=strchr(ligne, '=')) *ptrToken='\0';
            ptrLine=ptrToken+1;
            if (!(lpikTmp=(LPINIKEY)malloc(sizeof(INIKEY)))) EXIT_FREE;
            INIKEY_ZERO(lpikTmp);
            if (isSectionNew==1)
            {
                lpinCurrent->lpikKey=lpikTmp; /* si il s'agit de la premi&#65533;re cl&#65533;e */
                lpikKey=lpikTmp;
            }
            else
            {
                lpikKey->lpikNext=lpikTmp;
                lpikKey=lpikTmp;
            }
            _strupr(ligne);
            if (((lpikKey->ptrValue=(char*)malloc(strlen(ptrLine)+1)) && (lpikKey->ptrKeyName=(char*)malloc(strlen(ligne)+1)))==0) EXIT_FREE
            strcpy(lpikKey->ptrValue, ptrLine);
            strcpy(lpikKey->ptrKeyName, ligne);
            isSectionNew=0;
        }
    }
    fclose(ptrFile);
    return lpinStart;
}

LPINI IniGetSection(char* ptrSectionName, LPINI lpinIni)
{
    while (lpinIni!=NULL)
    {
        if (lpinIni->ptrSectionName)
        {
            if (!strcmp(lpinIni->ptrSectionName, ptrSectionName)) return lpinIni;
        }
        lpinIni=lpinIni->lpinNext;
    }
    return NULL;
}

LPINIKEY IniGetKey(char* ptrVarName, LPINI lpinSection)
{
    LPINIKEY lpikSection=lpinSection->lpikKey;
    while (lpikSection)
    {
        if (lpikSection->ptrKeyName)
        {
            if(!strcmp(lpikSection->ptrKeyName, ptrVarName)) return lpikSection;
        }
        lpikSection=lpikSection->lpikNext;
    }
    return NULL;
}

int IniGetValue(char* ptrValue, int iLength, LPINIKEY lpikIniKey)
{
    if (lpikIniKey==NULL) return EXIT_FAILURE;
    strncpy(ptrValue, lpikIniKey->ptrValue, iLength);
    return 0;
}

int IniSetValue(char* ptrValue, LPINIKEY lpikIniKey)
{
    char* ptrTmp=NULL;
    if (lpikIniKey==NULL) return EXIT_FAILURE;
    ptrTmp=(char*)realloc(lpikIniKey->ptrValue, strlen(ptrValue));
    if (ptrTmp==NULL) return EXIT_FAILURE;
    strcpy(ptrTmp, ptrValue);
    lpikIniKey->ptrValue=ptrTmp;
    return 0;
}

LPINIKEY IniCreateKey(char* ptrKeyName, char* ptrValue, LPINI lpinSection)
{
    INIKEY *lpikTmp=NULL;
    LPINIKEY lpikSection=lpinSection->lpikKey;
    lpikTmp=(LPINIKEY)malloc(sizeof(INIKEY));
    if (lpikTmp==NULL) return NULL;
    INIKEY_ZERO(lpikTmp);
    if (lpinSection->lpikKey==NULL)
    {
        lpinSection->lpikKey=lpikTmp;
    }
    else
    {
        lpikTmp->lpikNext=lpikSection->lpikNext;
        lpikSection->lpikNext=lpikTmp;
    }
    lpikSection=lpikTmp;
    lpikSection->ptrKeyName=(char*)malloc(strlen(ptrKeyName)+1);
    lpikSection->ptrValue=(char*)malloc(strlen(ptrValue)+1);
    if (!(lpikSection->ptrValue && lpikSection->ptrKeyName)) return NULL;
    strcpy(lpikSection->ptrValue, ptrValue);
    strcpy(lpikSection->ptrKeyName, ptrKeyName);
    return lpikSection;
}

LPINI IniCreateSection(char* ptrSectionName, LPINI lpinIni)
{
    LPINI lpinTmp=NULL;
    if (lpinIni->ptrSectionName!=NULL)
    {
        lpinTmp=(LPINI)malloc(sizeof(INI));
        if (lpinTmp==NULL) return NULL;
        INI_ZERO(lpinTmp);
        lpinTmp->lpinNext=lpinIni->lpinNext;
        lpinIni->lpinNext=lpinTmp;
        lpinIni=lpinTmp;
    }
    lpinIni->ptrSectionName=(char*)malloc(strlen(ptrSectionName));
    if (lpinIni->ptrSectionName==NULL)
    {
        return 0;
    }
    strcpy(lpinIni->ptrSectionName, ptrSectionName);
    return lpinIni;
}

int IniSave(char* ptrFileName, LPINI lpinIni)
{
    FILE* ptrFile=NULL;
    LPINIKEY lpikKey=NULL;
    ptrFile=fopen(ptrFileName, "w");
    if (ptrFile==NULL) return EXIT_FAILURE;
    while (lpinIni)
    {
        if (lpinIni->ptrSectionName)
        {
            fprintf(ptrFile, "[%s]%c%c", lpinIni->ptrSectionName, 13 ,10);
            lpikKey=lpinIni->lpikKey;
            while (lpikKey)
            {
                if (lpikKey->ptrKeyName) fprintf(ptrFile, "%s=%s%c%c", lpikKey->ptrKeyName, lpikKey->ptrValue, 13,10);
                lpikKey=lpikKey->lpikNext;
            }
        }
        lpinIni=lpinIni->lpinNext;
    }
    fclose(ptrFile);
    return EXIT_SUCCESS;
}

void IniDeleteSection(LPINI lpinSection)
{
    free(lpinSection->ptrSectionName);
    lpinSection->ptrSectionName=NULL;
}

void IniDeleteKey(LPINIKEY lpikKey)
{
    free(lpikKey->ptrKeyName);
    lpikKey->ptrKeyName=NULL;
}

void IniFree(LPINI lpinIni)
{
    LPINIKEY lpikKey;
    LPINIKEY lpikTmp;
    LPINI lpinTmp;
    while (lpinIni!=NULL)
    {
        lpikKey=lpinIni->lpikKey;
        while (lpikKey!=NULL)
        {
            free(lpikKey->ptrKeyName);
            free(lpikKey->ptrValue);
            lpikTmp=lpikKey->lpikNext;
            free(lpikKey);
            lpikKey=lpikTmp;
        }
        free(lpinIni->ptrSectionName);
        lpinTmp=lpinIni->lpinNext;
        free(lpinIni);
        lpinIni=lpinTmp;
    }
}