#include <mbed.h>
#include "DS3234.h"

/*
 The below mentioned are the bits in Read mode.
 seconds 0x80
 minuntes 0x81
 hours  0x82
 day 0x83
 date 0x84
 month 0x85
 year 0x86
*/

void set(PinName pin, struct ts t)
{
   SPI spi(PTD6, PTD7, PTD5);
   uint8_t i, century;

    if (t.year > 2000) {
        century = 0x80;
        t.year_s = t.year - 2000;
    } else {
        century = 0;
        t.year_s = t.year - 1900;
    }

    uint8_t TimeDate[7] = { t.sec, t.min, t.hour, t.wday, t.mday, t.mon, t.year_s };
    for (i = 0; i <= 6; i++) {
       
        DigitalOut cs(pin);
        cs = 0;
        spi.write(i + 0x80);
        if (i == 5)
        spi.write(dectobcd(TimeDate[5]) + century);
        else
        spi.write(dectobcd(TimeDate[i]));
        cs = 1;
    }
    
}
void DS3234_get(PinName pin, struct ts *t)
{
     SPI spi(PTD6, PTD7, PTD5);
    uint8_t TimeDate[7];        //second,minute,hour,dow,day,month,year
    uint8_t century = 0;
    uint8_t i, n;
    uint16_t year_full;
    DigitalOut cs(pin);
    
    for (i = 0; i <= 6; i++) {
        cs = 0;
        spi.write(i + 0x00);
        n = spi.write(0x00);
        
        if (i == 5) {           // month address also contains the century on bit7
            TimeDate[5] = bcdtodec(n & 0x1F);
            century = (n & 0x80) >> 7;
        } else {
            TimeDate[i] = bcdtodec(n);
        }
    }

    if (century == 1)
        year_full = 2000 + TimeDate[6];
    else
        year_full = 1900 + TimeDate[6];

    t->sec = TimeDate[0];
    t->min = TimeDate[1];
    t->hour = TimeDate[2];
    t->mday = TimeDate[4];
    t->mon = TimeDate[5];
    t->year = year_full;
    t->wday = TimeDate[3];
    t->year_s = TimeDate[6];
}



uint8_t dectobcd(const uint8_t val)
{
    return ((val / 10 * 16) + (val % 10));
}

uint8_t bcdtodec(const uint8_t val)
{
    return ((val / 16 * 10) + (val % 16));
}
