//////////////////////////////////////////////////////////////////////////////////
// Company: edinburgh of university
// Engineer: ZEjun DU
// 
// Create Date: 2017/08/20 13:06:52
// Design Name: Inverted Pendulum Balancer
// Module Name: motor driver
// Tool Versions: “Keil 5” or “Mbed Complie Online”
// Description: this part is basic function of movement to control the motor according to PWM!!!!!!!
//                           
// 
//////////////////////////////////////////////////////////////////////////////////

#include "L298HBridge.h"
#include "mbed.h"
 
////////////////////////////////////////////////////////////
//this part is a independent function which control the movement based on L298n
////////////////////////////////////////////////////////////
L298HBridge::L298HBridge(PinName ENPin, PinName FWDPin, PinName REVPin) : _ENPin(ENPin), _FWDPin(FWDPin), _REVPin(REVPin) {
    _ENPin = 0; //PWM = 0%
    _FWDPin = 0; //PWM = 0% 
    _REVPin = 0; //PWM = 0%
    _ENPin.period(0.0002); //set PWM period to 2mS as default.
}

////////////////////////////////////////////////////////////
//this part is to move forward
////////////////////////////////////////////////////////////
void L298HBridge::Fwd() {    
    _FWDPin = 1;//enable foward pin 
    _REVPin = 0;//disable reverse pin
}

////////////////////////////////////////////////////////////
//this part is to move reserve
////////////////////////////////////////////////////////////
void L298HBridge::Rev() {
    _FWDPin = 0;//disable foward pin 
    _REVPin = 1;//enable reverse pin 
}

////////////////////////////////////////////////////////////
//this part is to stop the movement of the balancer
////////////////////////////////////////////////////////////
void L298HBridge::Stop() {
    _FWDPin = 0;//disable foward pin 
    _REVPin = 0;//disable reverse pin 
}

////////////////////////////////////////////////////////////
//this part is to control the force of the motor according to PWM
////////////////////////////////////////////////////////////
void L298HBridge::Speed(float DutyPercent) {    
    _ENPin = DutyPercent /1000;//set PWM pin
}