//////////////////////////////////////////////////////////////////////////////////
// Company: edinburgh of university
// Engineer: ZEjun DU
// 
// Create Date: 2017/08/20 13:06:52
// Design Name: Inverted Pendulum Balancer
// Module Name: distance sensor
// Tool Versions: “Keil 5” or “Mbed Complie Online”
// Description: this part is basic function of position to get distance from distance sensor hcsr04.cpp
//                           
// 
//////////////////////////////////////////////////////////////////////////////////

#include "hcsr04.h"


HCSR04::HCSR04(PinName TrigPin,PinName EchoPin):
    trigger(TrigPin), echo(EchoPin)
{
    pulsetime.stop();
    pulsetime.reset();
    echo.rise(this,&HCSR04::isr_rise);
    echo.fall(this,&HCSR04::isr_fall);
    trigger=0;
}

HCSR04::~HCSR04()
{
}

void HCSR04::isr_rise(void)
{
    pulsetime.start();
}

////////////////////////////////////////////////////////////
//this funcition is to trigger the distance sensor
//after triggering, the distance sensor will send a 40KHz signal
////////////////////////////////////////////////////////////
void HCSR04::start(void)
{
    trigger=1;
    wait_us(12);
    trigger=0;
}

////////////////////////////////////////////////////////////
//this funcition is to calculate the distance according the high level time of the ENCH pin
////////////////////////////////////////////////////////////
void HCSR04::isr_fall(void)
{
    pulsetime.stop();//stop the pulsetime
    pulsedur = pulsetime.read_us();//read the high level time
    distance= (pulsedur*343)/20000;//calculate the distance according to the high level time
    pulsetime.reset();//reset the variable
}

void HCSR04::rise (void (*fptr)(void))
{
    echo.rise(fptr);
}
void HCSR04::fall (void (*fptr)(void))
{
    echo.fall(fptr);
}

unsigned int HCSR04::get_dist_cm()
{
    return distance;
}
unsigned int HCSR04::get_pulse_us()
{
    return pulsedur;
}



/*******************************************************
   Here is a sample code usage
********************************************************* 
#include "hcsr04.h"
HCSR04  usensor(p25,p6);
int main()
{
    unsigned char count=0;
    while(1) {
        usensor.start();
        wait_ms(500); 
        dist=usensor.get_dist_cm();
        lcd.cls();
        lcd.locate(0,0);
        lcd.printf("cm:%ld",dist );
 
        count++;
        lcd.locate(0,1);
        lcd.printf("Distance =%d",count);
        
    }
*/