/**
 * @file MsgQueue.cpp
 * @brief Ble message queue 
 * Copyright 2015 SEVENCORE Co., Ltd.
 *
 * @author HyeongJun Kim 
 * @version 1.0.0  
 * @date 2015-08-19
*/
#include "MsgQueue.h"
#include "mbed.h"
/**
 ****************************************************************************************
 * @addtogroup ext_fota module
 * @brief Ble message Queue Class Method Definition.
 *
 * @{
 ****************************************************************************************
 */
namespace sevencore_fota{
/**
 ****************************************************************************************
 * @brief Ble Message Queue Constructor.
 * @param[in] Message Queue Size.
 * @detail Default size is 512
 ****************************************************************************************
 */    
MsgQueue::MsgQueue(int MaxSize):MaxNum(MaxSize)
{
    Front = NULL;
    Rear = NULL;
    ElemCnt = 0;
}
/**
 ****************************************************************************************
 * @brief Ble Message Queue Destructor.
 ****************************************************************************************
 */
MsgQueue::~MsgQueue(void)
{
}
/**
 ****************************************************************************************
 * @brief Add message in queue.
 * @param[in] Ble message void pointer.
 ****************************************************************************************
 */
void MsgQueue::EnQueue(void *vData)
{
    Element *tmp = new Element;
    tmp->Data = vData;
    tmp->Next = NULL;
    ElemCnt++;
    if( Front == NULL)
    {
        Front = tmp;
        Rear = tmp;
    }else
    {
        Rear->Next = tmp;
        Rear = tmp;
    }    
}
/**
 ****************************************************************************************
 * @brief Remove message in queue.
 * @return void pointer(*void)
 ****************************************************************************************
 */
void *MsgQueue::DeQueue(void)
{
    void *tmp;
    Element *tmpElem;
    
    if(Front == NULL)
        return NULL;
    
    ElemCnt--;
    tmpElem = Front;
    Front = tmpElem->Next;
    tmp = tmpElem->Data;
    free(tmpElem);
    
    return tmp;
}   
/**
 ****************************************************************************************
 * @brief Return queue element count.
 * @return Integer element count.
 ****************************************************************************************
 */
int MsgQueue::GetElementCount(void)
{
    return ElemCnt;
}
/**
 ****************************************************************************************
 * @brief Boolean that queue is empty.
 * @return Boolean.
 ****************************************************************************************
 */
bool MsgQueue::IsEmpty(void)
{
    if( Front == NULL)
        return false;
    else
        return true;
}

}//namespace
/// @} ext_fota module