/**
 * @file app_task.h
 * @brief Header file for application handlers for ble events and responses.
 * Copyright 2015 SEVENCORE Co., Ltd.
 *
 * @author HyeongJun Kim 
 * @version 1.0.0  
 * @date 2015-08-20
*/
#ifndef APP_TASK_H
#define APP_TASK_H
#include "gapm_task.h"
#include "gapc_task.h"
#include "BleMsgHandler.h"

/**
 ****************************************************************************************
 * @addtogroup dialog_fota module
 * @brief application handlers for ble events and responses.
 *
 * @{
 ****************************************************************************************
 */
namespace sevencore_fota{

/**
 ****************************************************************************************
 * @brief Handles GAPM_ADV_REPORT_IND event.
 *
 * @param[in] msgid     Id of the message received.
 * @param[in] param     Pointer to the parameters of the message.
 * @param[in] dest_id   ID of the receiving task instance (TASK_GAP).
 * @param[in] src_id    ID of the sending task instance.
 *
 * @return If the message was consumed or not.
 ****************************************************************************************
 */
int gapm_adv_report_ind_handler(unsigned short msgid,
                                struct gapm_adv_report_ind *param,
                                unsigned short dest_id,
                                unsigned short src_id);
                                
/**
 ****************************************************************************************
 * @brief Handles the DISS_CREATE_DB_CFM message.
 *
 * @param[in] msgid     Id of the message received.
 * @param[in] param     Pointer to the parameters of the message.
 * @param[in] dest_id   ID of the receiving task instance (TASK_GAP).
 * @param[in] src_id    ID of the sending task instance.
 * @param[in] BMH     Ble Message Handler class reference.
 *
 * @return If the message was consumed or not.
 ****************************************************************************************
 */                                
int diss_create_db_cfm_handler(unsigned short  msgid,
                               struct diss_create_db_cfm *param,
                               unsigned short  dest_id,
                               unsigned short  src_id,
                               BleMsgHandler* BMH);
 /**
 ****************************************************************************************
 * @brief Handles the FOTA_SERVER_CREATE_DB_CFM message.
 *
 * @param[in] msgid     Id of the message received.
 * @param[in] param     Pointer to the parameters of the message.
 * @param[in] dest_id   ID of the receiving task instance (TASK_GAP).
 * @param[in] src_id    ID of the sending task instance.
 * @param[in] BMH     Ble Message Handler class reference.
 *
 * @return If the message was consumed or not.
 ****************************************************************************************
 */                               
 int fota_server_create_db_cfm_handler(unsigned short  msgid,
                               struct fota_server_create_db_cfm *param,
                               unsigned short  dest_id,
                               unsigned short  src_id,
                               BleMsgHandler* BMH);
 /**
 ****************************************************************************************
 * @brief Handles Firmware Data Copy event.
 *
 * @param[in] msgid     Id of the message received.
 * @param[in] param     Pointer to the parameters of the message.
 * @param[in] dest_id   ID of the receiving task instance (TASK_GAP).
 * @param[in] src_id    ID of the sending task instance.
 * @param[in] BMH     Ble Message Handler class reference.
 *
 * @return If the message was consumed or not.
 ****************************************************************************************
 */                               
void fota_server_data_flash_ind_handler(unsigned short msgid,
                                  struct fota_server_data_flash_ind *param,
                                  unsigned short dest_id,
                                  unsigned short src_id,
                                  BleMsgHandler* BMH); 
/**
 ****************************************************************************************
 * @brief Handles the FAN_CONTROL_CREATE_DB_CFM message.
 *
 * @param[in] msgid     Id of the message received.
 * @param[in] param     Pointer to the parameters of the message.
 * @param[in] dest_id   ID of the receiving task instance (TASK_GAP).
 * @param[in] src_id    ID of the sending task instance.
 * @param[in] BMH     Ble Message Handler class reference.
 *
 * @return If the message was consumed or not.
 ****************************************************************************************
 */
void fan_control_create_db_cfm_handler(unsigned short msgid,
                                  struct fan_control_create_db_cfm *param,
                                  unsigned short dest_id,
                                  unsigned short src_id,
                                  BleMsgHandler* BMH);
/**
 ****************************************************************************************
 * @brief Handles the FAN_CONTROL_COMMAND_IND message.
 *
 * @param[in] msgid     Id of the message received.
 * @param[in] param     Pointer to the parameters of the message.
 * @param[in] dest_id   ID of the receiving task instance (TASK_GAP).
 * @param[in] src_id    ID of the sending task instance.
 * @param[in] BMH     Ble Message Handler class reference.
 *
 * @return If the message was consumed or not.
 ****************************************************************************************
 */
void fan_control_command_ind_handler(unsigned short msgid,
                                  struct fan_control_command_ind *param,
                                  unsigned short dest_id,
                                  unsigned short src_id,
                                  BleMsgHandler* BMH);
/**
 ****************************************************************************************
 * @brief Handles the LAMP_CONTROL_CREATE_DB_CFM message.
 *
 * @param[in] msgid     Id of the message received.
 * @param[in] param     Pointer to the parameters of the message.
 * @param[in] dest_id   ID of the receiving task instance (TASK_GAP).
 * @param[in] src_id    ID of the sending task instance.
 * @param[in] BMH     Ble Message Handler class reference.
 *
 * @return If the message was consumed or not.
 ****************************************************************************************
 */
void lamp_control_create_db_cfm_handler(unsigned short msgid,
                                  struct lamp_control_create_db_cfm *param,
                                  unsigned short dest_id,
                                  unsigned short src_id,
                                  BleMsgHandler* BMH);
/**
 ****************************************************************************************
 * @brief Handles the LAMP_CONTROL_COMMAND_IND message.
 *
 * @param[in] msgid     Id of the message received.
 * @param[in] param     Pointer to the parameters of the message.
 * @param[in] dest_id   ID of the receiving task instance (TASK_GAP).
 * @param[in] src_id    ID of the sending task instance.
 * @param[in] BMH     Ble Message Handler class reference.
 *
 * @return If the message was consumed or not.
 ****************************************************************************************
 */
void lamp_control_command_ind_handler(unsigned short msgid,
                                  struct lamp_control_command_ind *param,
                                  unsigned short dest_id,
                                  unsigned short src_id,
                                  BleMsgHandler* BMH);
/**
 ****************************************************************************************
 * @brief Handles ready indication from the GAP.
 *
 * @param[in] msgid     Id of the message received.
 * @param[in] param     Pointer to the parameters of the message.
 * @param[in] dest_id   ID of the receiving task instance (TASK_GAP).
 * @param[in] src_id    ID of the sending task instance.
 * @param[in] BMH     Ble Message Handler class reference.
 *
 * @return If the message was consumed or not.
 ****************************************************************************************
 */                                                           
int gapm_device_ready_ind_handler(unsigned short msgid,
                                  struct gap_ready_evt *param,
                                  unsigned short dest_id,
                                  unsigned short src_id,
                                  BleMsgHandler* BMH );
/**
 ****************************************************************************************
 * @brief Handle reset GAP request completion event.
 *
 * @param[in] msgid     Id of the message received.
 * @param[in] param     Pointer to the parameters of the message.
 * @param[in] dest_id   ID of the receiving task instance (TASK_GAP).
 * @param[in] src_id    ID of the sending task instance.
 * @param[in] BMH     Ble Message Handler class reference.
 *
 * @return If the message was consumed or not.
 ****************************************************************************************
 */                                  
int gapm_reset_completion_handler(unsigned short msgid,
                                  struct gapm_cmp_evt *param,
                                  unsigned short dest_id,
                                  unsigned short src_id,
                                  BleMsgHandler* BMH);
/**
 ****************************************************************************************
 * @brief Handles GAPM_CMP_EVT event for GAPM_SET_DEV_CONFIG_CMD.
 *
 * @param[in] msgid     Id of the message received.
 * @param[in] param     Pointer to the parameters of the message.
 * @param[in] dest_id   ID of the receiving task instance (TASK_GAP).
 * @param[in] src_id    ID of the sending task instance.
 * @param[in] BMH     Ble Message Handler class reference.
 *
 * @return If the message was consumed or not.
 ****************************************************************************************
 */
int gapm_set_dev_config_completion_handler(unsigned short msgid,
                                           struct gapm_cmp_evt *param,
                                           unsigned short dest_id,
                                           unsigned short src_id,
                                           BleMsgHandler* BMH);
/**
 ****************************************************************************************
 * @brief Handles Connection request indication event.
 *
 * @param[in] msgid     Id of the message received.
 * @param[in] param     Pointer to the parameters of the message.
 * @param[in] dest_id   ID of the receiving task instance (TASK_GAP).
 * @param[in] src_id    ID of the sending task instance.
 * @param[in] BMH     Ble Message Handler class reference.
 *
 * @return If the message was consumed or not.
 ****************************************************************************************
 */
int gapc_connection_req_ind_handler(uint16_t msgid,
                                    struct gapc_connection_req_ind *param,
                                    uint16_t dest_id,
                                    uint16_t src_id,
                                    BleMsgHandler* BMH);
/**
 ****************************************************************************************
 * @brief Handles Discconnection indication event.
 *
 * @param[in] msgid     Id of the message received.
 * @param[in] param     Pointer to the parameters of the message.
 * @param[in] dest_id   ID of the receiving task instance (TASK_GAP).
 * @param[in] src_id    ID of the sending task instance.
 * @param[in] BMH     Ble Message Handler class reference.
 *
 * @return If the message was consumed or not.
 ****************************************************************************************
 */
int gapc_disconnect_ind_handler(uint16_t msgid,
                                struct gapc_disconnect_ind *param,
                                uint16_t dest_id,
                                uint16_t src_id,
                                BleMsgHandler* BMH);


                                  
}//namespace

/// @} dialog_fota module

#endif//APP_TASK_H
