/**
 * @file MsgQueue.h
 * @brief Ble message queue 
 * Copyright 2015 SEVENCORE Co., Ltd.
 *
 * @author HyeongJun Kim 
 * @version 1.0.0  
 * @date 2015-08-19
*/

#ifndef MSGQUEUE_H
#define MSGQUEUE_H
/**
 ****************************************************************************************
 * @addtogroup ext_fota module
 * @brief Ble message Queue Class Header.
 *
 * @{
 ****************************************************************************************
 */
namespace sevencore_fota{    

struct Element
{
    void *Data;
    struct Element *Next;
};

class MsgQueue
{
public:
    /**
     ****************************************************************************************
     * @brief Ble message queue constructor
     ****************************************************************************************
     */   
    MsgQueue(int MaxSize = 512);
    /**
     ****************************************************************************************
     * @brief Ble message queue destructor
     ****************************************************************************************
     */
    ~MsgQueue(void);
    /**
     ****************************************************************************************
     * @brief Add message in queue
     ****************************************************************************************
     */
    void EnQueue(void *vData);
    /**
     ****************************************************************************************
     * @brief Remove message in queue
     ****************************************************************************************
     */
    void *DeQueue(void);
    /**
     ****************************************************************************************
     * @brief Return queue element count
     ****************************************************************************************
     */
    int GetElementCount(void);
    /**
     ****************************************************************************************
     * @brief Boolean that queue is empty
     ****************************************************************************************
     */
    bool IsEmpty(void);

private:
    Element *Front;
    Element *Rear;
    const int MaxNum;
    int ElemCnt;
   
};

}//namespace

/// @} ext_fota module

#endif //MSG_QUEUE_H

