/**
 * @file lamp_control_task.h
 * @brief Lamp Control Task Header.
 * Copyright 2015 SEVENCORE Co., Ltd.
 *
 * @author HyeongJun Kim 
 * @version 1.0.0  
 * @date 2015-09-02
*/

#ifndef LAMP_CONTROL_TASK_H_
#define LAMP_CONTROL_TASK_H_

/*
 * INCLUDE FILES
 ****************************************************************************************
*/


/**
 ****************************************************************************************
 * @addtogroup dialog_fota module
 * @brief Fota Server Task Header.
 *
 * @{
 ****************************************************************************************
 */
namespace sevencore_fota{


/*
 * DEFINES
 ****************************************************************************************
 */

/// Maximum number of fota server task instances
#define LAMP_CONTROL_IDX_MAX                 (1)
#define LAMP_CONTROL_MIN_SIZE                (1)
#define LAMP_CONTROL_MAX_SIZE                (4)

/*
 * ENUMERATIONS
 ****************************************************************************************
 */
 
///Attribue Table Indexes
enum
{
    LAMP_CONTROL_POWER_STATE_CHAR,
    LAMP_CONTROL_LIGHT_INTENSITY_CHAR,
    LAMP_CONTROL_LAMP_TIMER_CHAR,
    LAMP_CONTROL_RESIDUAL_TIME_CHAR,
    
    LAMP_CONTROL_CHAR_MAX,
};

/// Messages for Fota Server
enum
{
    /// Start lamp_control. Device connection
    LAMP_CONTROL_ENABLE_REQ = TASK_LAMP_CONTROL*1024,
    ///Create DataBase
    LAMP_CONTROL_CREATE_DB_REQ,
    ///Inform APP of database creation status
    LAMP_CONTROL_CREATE_DB_CFM,
    /// Disable confirm.
    LAMP_CONTROL_DISABLE_IND,
    //Set Request of The Attribute Value of  Fota Service Characteristics  
    LAMP_CONTROL_SET_CHAR_VAL_REQ,
    //Fan Control Command Indication
    LAMP_CONTROL_COMMAND_IND,
    /// Error Indication
    LAMP_CONTROL_ERROR_IND,
};


/*
 * API MESSAGES STRUCTURES
 ****************************************************************************************
 */


/// Parameters of the @ref LAMP_CONTROL_ENABLE_REQ message
struct lamp_control_enable_req

{
    /// Connection Handle
    uint16_t conhdl;
    /// Security level
    uint8_t sec_lvl;
};


/// Parameters of the @ref LAMP_CONTROL_CREATE_DB_REQ message
struct lamp_control_create_db_req
{
    /// Indicate if TXPS is supported or not
    uint16_t features;   
};


/// Parameters of the @ref LAMP_CONTROL_CREATE_DB_CFM message
struct lamp_control_create_db_cfm
{
    /// Status
    uint8_t status;
};


/// Parameters of the @ref LAMP_CONTROL_SET_CHAR_VAL_REQ message - shall be dynamically allocated
struct lamp_control_set_char_val_req
{
    /// Characteristic Code
    uint8_t char_code;
    /// Value length
    uint8_t val_len;
    /// Value
    uint8_t val[4];
};


/// Parameters of the @ref LAMP_CONTROL_DISABLE_IND message
struct lamp_control_disable_ind
{
    /// Connection Handle
    uint16_t conhdl;
};

/// Parameters of the @ref LAMP_CONTROL_COMMAND_IND message
struct lamp_control_command_ind
{
    uint8_t char_code;
    uint8_t command;
    uint32_t residual_time;
};


}//namespace

/// @} dialog_fota module
#endif // LAMP_CONTROL_TASK_H_
