/**
 * @file main.cpp
 * @brief interface configuration & main loop start
 * Copyright 2015 SEVENCORE Co., Ltd.
 *
 * @author HyeongJun Kim 
 * @version 1.0.0  
 * @since 2015-08-17
*/


#include "mbed.h"
#include "cmsis_os.h"
#include "BleMsgHandler.h"
#include "fan_control_task.h"
#include "dialog_fota_config.h"
#include "app.h"

Serial hostpc(USBTX,USBRX);
Serial device(p13,p14);
LocalFileSystem local("local");               // Create the local filesystem
DigitalOut myled(LED1);
DigitalOut myled2(LED2);
DigitalOut myled3(LED3);
DigitalOut myled4(LED4);

DigitalOut port18(p18);//mid
DigitalOut port19(p19);//low
DigitalOut port20(p20);//high

uint8_t Timer_flag;
uint32_t Residual_Time;

using namespace sevencore_fota;


void FanTimer(void const *threadarg)
{
    Timer_flag = 0;
    Residual_Time = 0;
    BleMsgHandler *BMH;
    BMH = (struct BleMsgHandler *) threadarg;
    while(true)
    {
        if( Timer_flag == 1 && Residual_Time == 0 )
        {
            hostpc.printf("Power off!!\n");
            if( port18 == 1 || port19 == 1 || port20 == 1 )
                port18 = port19 = port20 = 0;
            Timer_flag = 0;
            /*{
                uint8_t fota_normal = 0;
                uint8_t *msg;
                struct fan_control_set_char_val_req char_set_req;
                unsigned short msg_size = 1+sizeof(ble_hdr)+ sizeof(fan_control_set_char_val_req)-(4-FAN_CONTROL_MIN_SIZE);
                // Fill in the parameter structure
                char_set_req.char_code     = FAN_CONTROL_POWER_STATE_CHAR;
                char_set_req.val_len       = FAN_CONTROL_MIN_SIZE;
                memcpy(&char_set_req.val[0], &fota_normal, sizeof(fota_normal));
                
                msg = new uint8_t[msg_size];
                
                BMH->BleMsgAlloc(FAN_CONTROL_SET_CHAR_VAL_REQ
                    ,TASK_FAN_CONTROL, TASK_GTL
                    ,sizeof(struct fan_control_set_char_val_req)-(4-FAN_CONTROL_MIN_SIZE)
                    ,&char_set_req,msg );
                // Send the message
                BMH->BleSendMsg(msg,msg_size);                
                free(msg);
            }
            */
            
        }
    
        if( Timer_flag == 1 )
        {
            osDelay(1000);
            if(Residual_Time > 0){
                hostpc.printf("Residual Time = %d, minus 1 second!!\n",Residual_Time );
                Residual_Time--;
            }
        }
    }
}

void t0(void const *argument) {FanTimer(argument);}
osThreadDef(t0, osPriorityNormal, DEFAULT_STACK_SIZE);

void led_setting_one(void){
    myled = 1;
    myled2 = 1;
    myled3 = 1;
    myled4 = 1;
}

void led_setting_zero(void){
    myled = 1;
    myled2 = 0;
    myled3 = 0;
    myled4 = 0;
}

int main() {
    wait(0.5);
    myled = 1;
    wait(0.5);
    myled = 0;
    wait(0.5);
    myled = 1;
    wait(0.5);
    myled = 0;
    wait(0.5);
    led_setting_zero(); 
    wait(0.5);
    hostpc.baud(9600);
    wait(0.5);
    device.baud(115200);
    device.set_flow_control(device.RTSCTS,P2_7,p12);
    wait(0.5);
    
    BleMsgHandler myfota(&device,&hostpc);   
    osThreadCreate( osThread(t0), (void *)&myfota );
    
    myfota.PrintTitle();
    app_rst_gap(&myfota);
    
    for(int i = 0; i < 200; i++) {
        myfota.BleReceiveMsg();
        myfota.BleMsgHandle();
    }
    
    while(1) {
        myled = 1;
        wait(0.5);
        myled = 0;
        wait(0.5);
    }
    
}
