/**
 * @file gap.h
 * @brief Generic Access Profile.
 * Copyright 2015 SEVENCORE Co., Ltd.
 *
 * @author HyeongJun Kim 
 * @version 1.0.0  
 * @date 2015-08-20
*/
#ifndef GAP_H
#define GAP_H
#include "dialog_fota_config.h"

/**
 ****************************************************************************************
 * @addtogroup dialog_fota module
 * @brief Generic Access Profile.
 *
 * @{
 ****************************************************************************************
 */

namespace sevencore_fota{

#define KEY_LEN             0x10


/// Generic Security key structure
struct gap_sec_key
{
    /// Key value MSB -> LSB
    uint8_t key[KEY_LEN];
};

/// Address information about a device address
struct gap_bdaddr
{
    /// BD Address of device
    struct bd_addr addr;
    /// Address type of the device 0=public/1=private random
    uint8_t addr_type;
};

/// Advertising mode
enum gap_adv_mode
{
    /// Mode in non-discoverable
    GAP_NON_DISCOVERABLE,
    /// Mode in general discoverable
    GAP_GEN_DISCOVERABLE,
    /// Mode in limited discoverable
    GAP_LIM_DISCOVERABLE,
    /// Broadcaster mode which is a non discoverable and non connectable mode.
    GAP_BROADCASTER_MODE,
};

/// Role GAP
enum gap_role
{
    /// No role set yet
    GAP_NO_ROLE    = 0x00,

    /// Observer role
    GAP_OBSERVER_SCA    = 0x01,

    /// Broadcaster role
    GAP_BROADCASTER_ADV = 0x02,

    /// Master/Central role
    GAP_CENTRAL_MST     = (0x04 | GAP_OBSERVER_SCA),

    /// Peripheral/Slave role
    GAP_PERIPHERAL_SLV  = (0x08 | GAP_BROADCASTER_ADV),
};
/// Authentication mask
enum gap_auth_mask
{
    /// No Flag set
    GAP_AUTH_NONE = 0,
    /// Bond authentication
    GAP_AUTH_BOND = (1 << 0),
    /// Man In the middle protection
    GAP_AUTH_MITM = (1 << 2),
};


/// Authentication Requirements
enum gap_auth
{
    /// No MITM No Bonding
    GAP_AUTH_REQ_NO_MITM_NO_BOND = (GAP_AUTH_NONE),
    /// No MITM Bonding
    GAP_AUTH_REQ_NO_MITM_BOND    = (GAP_AUTH_BOND),
    /// MITM No Bonding
    GAP_AUTH_REQ_MITM_NO_BOND    = (GAP_AUTH_MITM),
    /// MITM and Bonding
    GAP_AUTH_REQ_MITM_BOND       = (GAP_AUTH_MITM | GAP_AUTH_BOND),
    GAP_AUTH_REQ_LAST
};

/// Authorization setting
enum gap_authz
{
    /// Authorization not set, application informed when authorization requested
    GAP_AUTHZ_NOT_SET = 0x00,
    /// Authorization request automatically accepted
    GAP_AUTHZ_ACCEPT  = 0x01,
    /// Authorization request automatically rejected
    GAP_AUTHZ_REJECT  = 0x02,
};
    
}//namespace

/// @} dialog_fota module

#endif//GAP_H