/**
 * @file fota_server_task.h
 * @brief Fota Server Task Header.
 * Copyright 2015 SEVENCORE Co., Ltd.
 *
 * @author HyeongJun Kim 
 * @version 1.0.0  
 * @date 2015-08-20
*/
#ifndef FOTA_SERVER_TASK_H
#define FOTA_SERVER_TASK_H

/**
 ****************************************************************************************
 * @addtogroup dialog_fota module
 * @brief Fota Server Task Header.
 *
 * @{
 ****************************************************************************************
 */
namespace sevencore_fota{
    
#define APP_FOTA_SERVER_FIRMWARE_VERSION       ("01-00-00")
#define APP_FOTA_SERVER_FIRMWARE_VERSION_LEN   (8)
#define APP_FOTA_SERVER_FIRMWARE_NEW_VERSION            ("00-00-00")
#define APP_FOTA_SERVER_FIRMWARE_NEW_VERSION_LEN        (8)
    
///Attribue Table Indexes
enum
{
    FOTA_SERVER_FIRMWARE_VERSION_CHAR,
    FOTA_SERVER_FIRMWARE_NEW_VERSION_CHAR,
    FOTA_SERVER_FIRMWARE_DATA_CHAR,
    FOTA_SERVER_SEQUENCE_NUMBER_CHAR,
    FOTA_SERVER_CHECKSUM_DATA_CHAR,
    FOTA_SERVER_FIRMWARE_DATA_CHECK_CHAR,
    FOTA_SERVER_FIRMWARE_UPGRADE_TYPE_CHAR,
    FOTA_SERVER_FIRMWARE_STATUS_CHAR,
    FOTA_SERVER_RESET_CHAR,
    
    FOTA_SERVER_CHAR_MAX,
};

/// Messages for Fota Server
enum
{
    /// Start fota_server. Device connection
    FOTA_SERVER_ENABLE_REQ = 55296,
    ///Create DataBase
    FOTA_SERVER_CREATE_DB_REQ,
    ///Inform APP of database creation status
    FOTA_SERVER_CREATE_DB_CFM,
    /// Disable confirm.
    FOTA_SERVER_DISABLE_IND,
    //Set Request of The Attribute Value of  Fota Service Characteristics  
    FOTA_SERVER_SET_CHAR_VAL_REQ,
    //Flash new firmware data on flash memory
    FOTA_SERVER_DATA_FLASH_IND,
    /// Error Indication
    FOTA_SERVER_ERROR_IND,
};   
/// include service entry element
struct att_incl_desc
{
    /// start handle value of included service
    unsigned short start_hdl;
    /// end handle value of included service
    unsigned short end_hdl;
    /// attribute value UUID
    unsigned short uuid;
};

/// Parameters of the @ref FOTA_SERVER_CREATE_DB_REQ message
struct fota_server_create_db_req
{
    /// Indicate if TXPS is supported or not
    uint16_t features;
    /// Include Service Info
    struct att_incl_desc ext_diss_ref;
    
};    

/// Parameters of the @ref FOTA_SERVER_CREATE_DB_CFM message
struct fota_server_create_db_cfm
{
    /// Status
    uint8_t status;
};

/// Parameters of the @ref FOTA_SERVER_SET_CHAR_VAL_REQ message - shall be dynamically allocated
struct fota_server_set_char_val_req
{
    /// Characteristic Code
    uint8_t char_code;
    /// Value length
    uint8_t val_len;
    /// Value
    uint8_t val[18];
};

/// Parameters of the @ref FOTA_SERVER_ENABLE_REQ message
struct fota_server_enable_req
{
    /// Connection Handle
    uint16_t conhdl;
    /// Security level
    uint8_t sec_lvl;
};

/// Parameters of the @ref FOTA_SERVER_DATA_FLASH_IND message - shall be dynamically allocated
struct fota_server_data_flash_ind
{
    // Firmware code size
    uint16_t code_size;
    // Firmware Version
    uint8_t version[8];
};

    
    
}//namespace

/// @} dialog_fota module
#endif//FOTA_SERVER_TASK_H
