/**
 * @file diss_task.h
 * @brief Device Information Service Server Header.
 * Copyright 2015 SEVENCORE Co., Ltd.
 *
 * @author HyeongJun Kim 
 * @version 1.0.0  
 * @date 2015-08-20
*/
#ifndef DISS_TASK_H
#define DISS_TASK_H

/**
 ****************************************************************************************
 * @addtogroup dialog_fota module
 * @brief Device Information Service Server Header
 *
 * @{
 ****************************************************************************************
 */
namespace sevencore_fota{

#define STR_MAX_LEN     (18)


///Attribute Table Indexes
enum
{
    DIS_MANUFACTURER_NAME_CHAR,
    DIS_MODEL_NB_STR_CHAR,
    DIS_SERIAL_NB_STR_CHAR,
    DIS_HARD_REV_STR_CHAR,
    DIS_FIRM_REV_STR_CHAR,
    DIS_SW_REV_STR_CHAR,
    DIS_SYSTEM_ID_CHAR,
    DIS_IEEE_CHAR,
    DIS_PNP_ID_CHAR,

    DIS_CHAR_MAX,
};


/// Messages for Device Information Service Server
enum
{
    ///Add a DIS instance into the database
    DISS_CREATE_DB_REQ = 28672,
    ///Inform APP of database creation status
    DISS_CREATE_DB_CFM,
    ///Set the value of an attribute
    DISS_SET_CHAR_VAL_REQ,

    ///Start the Device Information Service Task - at connection
    DISS_ENABLE_REQ,

    /// Inform the application that the profile service role task has been disabled after a disconnection
    DISS_DISABLE_IND,

    ///Error indication to Host
    DISS_ERROR_IND,
};

///Database Configuration Flags
enum
{
    ///Indicate if Manufacturer Name String Char. is supported
    DIS_MANUFACTURER_NAME_CHAR_SUP       = 0x0001,
    ///Indicate if Model Number String Char. is supported
    DIS_MODEL_NB_STR_CHAR_SUP            = 0x0002,
    ///Indicate if Serial Number String Char. is supported
    DIS_SERIAL_NB_STR_CHAR_SUP           = 0x0004,
    ///Indicate if Hardware Revision String Char. supports indications
    DIS_HARD_REV_STR_CHAR_SUP            = 0x0008,
    ///Indicate if Firmware Revision String Char. is writable
    DIS_FIRM_REV_STR_CHAR_SUP            = 0x0010,
    ///Indicate if Software Revision String Char. is writable
    DIS_SW_REV_STR_CHAR_SUP              = 0x0020,
    ///Indicate if System ID Char. is writable
    DIS_SYSTEM_ID_CHAR_SUP               = 0x0040,
    ///Indicate if IEEE Char. is writable
    DIS_IEEE_CHAR_SUP                    = 0x0080,
    ///Indicate if PnP ID Char. is writable
    DIS_PNP_ID_CHAR_SUP                  = 0x0100,

    ///All features are supported
    DIS_ALL_FEAT_SUP                     = 0x01FF,
};
  
/// Parameters of the @ref DISS_CREATE_DB_CFM message
struct diss_create_db_cfm
{
    ///Status
    uint8_t status;
};

/// Parameters of the @ref DISS_SET_CHAR_VAL_REQ message - shall be dynamically allocated
struct diss_set_char_val_req
{
    /// Characteristic Code
    uint8_t char_code;
    /// Value length
    uint8_t val_len;
    /// Value
    uint8_t val[STR_MAX_LEN];
};

/// Parameters of the @ref DISS_CREATE_DB_REQ message
struct diss_create_db_req
{
    ///Database configuration
    uint16_t features;
};

/// Parameters of the @ref DISS_ENABLE_REQ message
struct diss_enable_req
{
    ///Connection handle
    uint16_t conhdl;
    /// security level: b0= nothing, b1=unauthenticated, b2=authenticated, b3=authorized; b1 or b2 and b3 can go together
    uint8_t sec_lvl;
    ///Type of connection
    uint8_t con_type;
};

}//namespace

/// @} dialog_fota module

#endif//DISS_TASK_H
