/**
 ****************************************************************************************
 *
 * @file mbed_fota_config.h
 *
 * @brief  SevenCore Firmware Over The Air Service for External Processor Configuration Code
 *
 * Copyright (C) 2015 SevenCore and its Affiliates, unpublished work
 * This computer program includes Confidential, Proprietary Information and is a Trade Secret 
 * of SevenCore and its Affiliates. All use, disclosure, and/or reproduction is prohibited 
 * unless authorized in writing. All Rights Reserved.
 *
 ****************************************************************************************
*/

#ifndef MBED_FOTA_CONFIG_H
#define MBED_FOTA_CONFIG_H

/*
 * INCLUDE FILES
 ****************************************************************************************
 */


/*
 * ENUMERATIONS
 ****************************************************************************************
 */
 
 
 /*
 * DEFINES
 ****************************************************************************************
 */

#define GAPM_CMP_EVT 13312
#define GAPM_DEVICE_READY_IND 13313
#define GAPM_RESET_CMD 13314
#define TASK_GAPM 13
#define TASK_GTL 63
#define GAPM_RESET 0x01
#define TASK_GTL   63
#define FE_MSG_PACKET_TYPE 0x05
#define MAX_PACKET_LENGTH 350
#define MIN_PACKET_LENGTH 9
 



typedef struct {
    unsigned short bType;
    unsigned short bDstid;
    unsigned short bSrcid;
    unsigned short bLength;
} ble_hdr;


 typedef struct {
    unsigned short bType;
    unsigned short bDstid;
    unsigned short bSrcid;
    unsigned short bLength;
    unsigned char  bData[1];
} ble_msg;

typedef uint16_t ke_msg_id_t;
typedef uint8_t ke_state_t;
typedef uint16_t ke_task_id_t;

///  Reset link layer and the host command
struct gapm_reset_cmd
{
    /// GAPM requested operation:
    /// - GAPM_RESET: Reset BLE subsystem: LL and HL.
    uint8_t operation;
};


 /*
 * GLOBAL VALUE
 ****************************************************************************************
 */


#endif //MEBED_FOTA_CONFIG_H