#include "mbed.h"
#include "msg_queue.h"


class Serial_Communicator
{
public:
    
    Serial_Communicator(Serial* _device);
    Serial_Communicator(Serial* _device, Serial* _hostpc);
    ~Serial_Communicator(void);
    
    void print_title(void);
    
    void BleMsgAlloc(unsigned short id,unsigned short dest_id, unsigned short src_id, unsigned short data_len,void *pdata, uint8_t *msg);
    int BleSendMsg(uint8_t *msg,unsigned short size);
    void BleMsgEnQueue(uint8_t *msg);
    uint8_t *BleMsgDeQueue(void);
    void BleReceiveMsg(void);
    bool IsQueueEmpty(void);
   

private:
    bool debug_flag;
    Serial *hostpc;
    Serial *device;
    Msg_Queue *queue;
    uint8_t FE_MSG_PACKET_TYPE;
    int MAX_PACKET_LENGTH;
    unsigned char bReceiveState;
    unsigned short wDataLength;
    unsigned short wReceivePos;
    unsigned char bHdrBytesRead;
    unsigned char bReceiveElementArr[512];
   
};

