#include "blemsg_handler.h"


BleMsg_Handler::BleMsg_Handler(void)
{
}


BleMsg_Handler::~BleMsg_Handler(void)
{
}


void BleMsg_Handler::HandleBleMsg(uint8_t *msg)
{
    ble_hdr msg_hdr;
    memcpy(msg_hdr, &msg[1], sizeof(msg_hdr));
    
    if( msg_hdr.bDstid != TASK_GTL )
        return;
    
    switch( msg_hdr.bType )
    {
        case GAPM_CMP_EVT:  
            HadleGapmCmpEvt(msg);
            break; 
        // Event triggered to inform that lower layers are ready
        case GAPM_DEVICE_READY_IND: 
            gapm_device_ready_ind_handler(msg);
            break;
        case GAPM_ADV_REPORT_IND:
            gapm_adv_report_ind_handler(msg);
            break;
            
        case GAPC_CMP_EVT:  
            HadleGapcCmpEvt(msg);
            break; 
        // Indicate that a connection has been established
        case GAPC_CONNECTION_REQ_IND:
            gapc_connection_req_ind_handler(msg);
            break;
        // Indicate that a link has been disconnected
        case GAPC_DISCONNECT_IND:
            gapc_disconnect_ind_handler(msg);
            break;
        case GAPC_CON_RSSI_IND:
            gapc_con_rssi_ind_handler(msg);
            break;
        case GAPC_BOND_REQ_IND:
            gapc_bond_req_ind_handler(msg);
            break;
        // Bonding information indication message
        case GAPC_BOND_IND:
             gapc_bond_ind_handler(msg);
            break;
        // Encryption requested by peer device indication message.
        case GAPC_ENCRYPT_REQ_IND:
            gapc_encrypt_req_ind_handler(msg);
            break;
        // Encryption information indication message
        case GAPC_ENCRYPT_IND:
            gapc_encrypt_ind_handler(msg);
            break;
            
        case DISS_CREATE_DB_CFM:
            diss_create_db_cfm_handler(msg);
            break;
        case DISS_DISABLE_IND:
            break;
        case DISS_ERROR_IND:
            break; 
               
        default:
            break;
    }
        
}

