#include "serial_communicator.h"

Serial_Communicator::Serial_Communicator(Serial* _device)
{
    debug_flag = 0;
    device = _device;
    queue = new Msg_Queue(512);
    FE_MSG_PACKET_TYPE = 0x05;
    MAX_PACKET_LENGTH = 350;
    bReceiveState = 0;
    wDataLength = 0;
    wReceivePos = 0;
    bHdrBytesRead = 0;
    memset(bReceiveElementArr,0,512);
}

Serial_Communicator::Serial_Communicator(Serial* _device, Serial* _hostpc)
{
    debug_flag = 1;
    device = _device;
    hostpc = _hostpc;
    queue = new Msg_Queue(512);
    FE_MSG_PACKET_TYPE = 0x05;
    MAX_PACKET_LENGTH = 350;
    bReceiveState = 0;
    wDataLength = 0;
    wReceivePos = 0;
    bHdrBytesRead = 0;
    memset(bReceiveElementArr,0,512);
}

Serial_Communicator::~Serial_Communicator(void)
{
    free(queue);
}

void Serial_Communicator::print_title()
{
    if( debug_flag == 1)
        hostpc->printf("FOTA CLASS START!\n");
}

void Serial_Communicator::BleMsgAlloc( unsigned short id,
                                 unsigned short dest_id,
                                 unsigned short src_id,
                                 unsigned short data_len,
                                 void *pdata,
                                 uint8_t *msg )
{
    memset(msg,0,sizeof(msg));
    msg[0] = 0x05;
    memcpy(&msg[1],&id,sizeof(unsigned short));
    memcpy(&msg[1+1*sizeof(unsigned short)],&dest_id,sizeof(unsigned short));
    memcpy(&msg[1+2*sizeof(unsigned short)],&src_id,sizeof(unsigned short));
    memcpy(&msg[1+3*sizeof(unsigned short)],&data_len,sizeof(unsigned short));
    memcpy(&msg[1+4*sizeof(unsigned short)],pdata,data_len);
}

int Serial_Communicator::BleSendMsg(uint8_t *msg,unsigned short size)
{
    int cnt = 0;
    if(debug_flag == 1)
        hostpc->printf("send size = %hu\n",size);
        
    for(int i=0; i < size; i++)
    {
        if( device->writeable())
        {
            if(debug_flag == 1)
                hostpc->printf("%02X ", msg[i]);
            device->putc(msg[i]);
            cnt++;
        }
    }
    return cnt;    
}

void Serial_Communicator::BleMsgEnQueue(uint8_t *msg)
{
    queue->EnQueue((void *)msg);
}

uint8_t *Serial_Communicator::BleMsgDeQueue(void)
{
    return (uint8_t *)queue->DeQueue();
}

bool Serial_Communicator::IsQueueEmpty(void)
{
    return queue->IsEmpty();
}

void Serial_Communicator::BleReceiveMsg(void)
{
    unsigned char tmp;
    
    
    //while(true)
    //{
        if(device->readable())
        {
            tmp = device->getc();
            switch(bReceiveState)
            {
                case 0:
                    if( tmp == FE_MSG_PACKET_TYPE )
                    {
                        bReceiveState = 1;
                        wDataLength = 0;
                        wReceivePos = 0;
                        bHdrBytesRead = 0;
                        
                        bReceiveElementArr[wReceivePos] = tmp;
                        wReceivePos++;
                        if(debug_flag == 1)
                            hostpc->printf("\n[Receiver] Packet Type |: %02X \n", tmp);
                    }else
                    {
                        if(debug_flag == 1)
                            hostpc->printf("\n[Receiver] Packet Type Error |: %02X \n", tmp);
                    }
                    break;
                case 1:
                    if(debug_flag == 1)
                        hostpc->printf("R-%02X ",tmp);
                    bHdrBytesRead++;
                    bReceiveElementArr[wReceivePos] = tmp;
                    wReceivePos++;
                    if( bHdrBytesRead == 6 )
                        bReceiveState = 2;
                    break;
                case 2:
                    if(debug_flag == 1)
                        hostpc->printf("R-%02X ",tmp);
                    wDataLength += tmp;
                    if( wDataLength > MAX_PACKET_LENGTH )
                        bReceiveState = 0;
                    else
                    {
                        bReceiveElementArr[wReceivePos] = tmp;
                        wReceivePos++;
                        bReceiveState = 3;
                    }
                    break;
                case 3:
                    if( debug_flag == 1 )
                        hostpc->printf("R-%02X ",tmp);
                    wDataLength += (unsigned short) (tmp*256);
                    if( wDataLength > MAX_PACKET_LENGTH )
                    {
                        if( debug_flag == 1 )
                            hostpc->printf("\n[Receiver] Over SIZE: %d ", wDataLength);
                        bReceiveState = 0;
                    }else if (wDataLength == 0)
                    {
                        if( debug_flag == 1 )
                            hostpc->printf("\n[Receiver] Zero SIZE: %d ", wDataLength);
                        uint8_t *msg;
                        msg = new uint8_t[wReceivePos];
                        memcpy(msg,bReceiveElementArr,wReceivePos);
                        BleMsgEnQueue(msg);
                        bReceiveState = 0;
                    }else
                    {
                        bReceiveElementArr[wReceivePos] = tmp;
                        wReceivePos++;
                        bReceiveState = 4;
                    }
                    break;
                case 4:
                    if( debug_flag == 1 )
                        hostpc->printf("R-%02X ",tmp);
                    bReceiveElementArr[wReceivePos] = tmp;
                    wReceivePos++;
                    // 9 = 1(first byte = FE_MSG_PACKET_TYPE) + 2(type) +2(dstid) +2(srcid) +2(length size)
                    if(wReceivePos == wDataLength + 9)
                    {
                        uint8_t *msg;
                        msg = new uint8_t[wReceivePos];
                        memcpy(msg,bReceiveElementArr,wReceivePos);
                        BleMsgEnQueue(msg);
                        bReceiveState = 0;
                        if( debug_flag == 1 )
                            hostpc->printf("\n[Receiver] Rcv Data SIZE: %d ", wDataLength);
                    }
                    break;
                default:
                    if(debug_flag == 1)
                        hostpc->printf("ERROR STRAGE STATE\n");
                    break;
            }
        }
    //}
}


