#include "mbed.h"
#include "serial_communicator.h"
#include "mbed_fota_config.h"


Serial hostpc(USBTX,USBRX);
Serial device(p13,p14);

DigitalOut led1(LED1);

void func1()
{
    while(1)
    {  
        wait(1);
        led1 = !led1;
    }    
}

int main() {
    Serial_Communicator Fota_comm(&device, &hostpc);
    // Serial Setting
    hostpc.baud(115200);
    device.baud(115200);
    
    // print title
    Fota_comm.print_title();
    uint8_t *a,*c;
    uint8_t b[1];
    b[0] = 0x01;
    unsigned short array_size = 1+sizeof(ble_hdr)+sizeof(gapm_reset_cmd);
    a = new uint8_t[array_size];
    hostpc.printf("msg size = %hu\n", array_size);
    Fota_comm.BleMsgAlloc(GAPM_RESET_CMD,TASK_GAPM,TASK_GTL,1,b,a);
    
    ble_hdr test;
    gapm_reset_cmd data_test;
    
    memcpy(&test,&a[1],sizeof(ble_hdr));
    memcpy(&data_test,&a[1+sizeof(ble_hdr)],sizeof(gapm_reset_cmd));
    
    hostpc.printf("packet_type = 0x%02X\n", a[0]);
    hostpc.printf("id = %hu, dst = %hu, src = %hu, len = %hu\n", test.bType,test.bDstid,test.bSrcid,test.bLength);
    hostpc.printf("data = %02X\n",data_test.operation);
    
    hostpc.printf("send cnt = %d \n",Fota_comm.BleSendMsg(a,array_size));
    
    Fota_comm.BleMsgEnQueue(a);
    c = Fota_comm.BleMsgDeQueue();
    
    memcpy(&test,&c[1],sizeof(ble_hdr));
    memcpy(&data_test,&c[1+sizeof(ble_hdr)],sizeof(gapm_reset_cmd));
    
    hostpc.printf("#c packet_type = 0x%02X\n", c[0]);
    hostpc.printf("#c id = %hu, dst = %hu, src = %hu, len = %hu\n", test.bType,test.bDstid,test.bSrcid,test.bLength);
    hostpc.printf("#c data = %02X\n",data_test.operation);
    
    free(c);
    free(a);
    
    while(Fota_comm.IsQueueEmpty() == false)
    {
        Fota_comm.BleReceiveMsg();
    }
    c = Fota_comm.BleMsgDeQueue();
    
    memcpy(&test,&c[1],sizeof(ble_hdr));
    memcpy(&data_test,&c[1+sizeof(ble_hdr)],sizeof(gapm_reset_cmd));
    
    hostpc.printf("#receive packet_type = 0x%02X\n", c[0]);
    hostpc.printf("#receive id = %hu, dst = %hu, src = %hu, len = %hu\n", test.bType,test.bDstid,test.bSrcid,test.bLength);
    hostpc.printf("#receive data = %02X\n",data_test.operation);
    
    free(c);
    while(1)
    {
        func1();
        //serial receive process      
    }

}
