#include "msg_queue.h"
#include "mbed.h"

Msg_Queue::Msg_Queue(int MaxSize):MaxNum(MaxSize)
{
    Front = NULL;
    Rear = NULL;
    ElemCnt = 0;
}

Msg_Queue::~Msg_Queue(void)
{
}

void Msg_Queue::EnQueue(void *vData)
{
    Element *tmp = new Element;
    tmp->Data = vData;
    tmp->Next = NULL;
    ElemCnt++;
    if( Front == NULL)
    {
        Front = tmp;
        Rear = tmp;
    }else
    {
        Rear->Next = tmp;
        Rear = tmp;
    }    
}

void *Msg_Queue::DeQueue(void)
{
    void *tmp;
    Element *tmpElem;
    
    if(Front == NULL)
        return NULL;
    
    ElemCnt--;
    tmpElem = Front;
    Front = tmpElem->Next;
    tmp = tmpElem->Data;
    free(tmpElem);
    
    return tmp;
}   

int Msg_Queue::GetElementCount(void)
{
    return ElemCnt;
}

bool Msg_Queue::IsEmpty(void)
{
    if( Front == NULL)
        return false;
    else
        return true;
}

 