/* Only for NUCLEO boards: prevent compiling for MOTE_L152RC and typeABZ discovery */
#if defined(TARGET_FF_ARDUINO) || defined(TARGET_FF_ARDUINO_UNO) && !defined(TARGET_DISCO_L072CZ_LRWAN1)
#include "radio.h"
#ifdef SX127x_H 

SPI spi(D11, D12, D13); // mosi, miso, sclk
//                  dio0, dio1, nss, spi, rst
SX127x Radio::radio(  D2,   D3, D10, spi, A0); // sx127[62] arduino shield
SX127x_lora Radio::lora(radio);
SX127x_fsk Radio::fsk(radio);

InterruptIn Radio::dio0(D2);
InterruptIn Radio::dio1(D3);

typedef enum {
    SHIELD_TYPE_NONE = 0,
    SHIELD_TYPE_LAS,
    SHIELD_TYPE_MAS,
} shield_type_e;
shield_type_e shield_type;

#ifdef TARGET_FF_MORPHO
DigitalOut pc3(PC_3);   // debug RX indication, for nucleo boards
#endif /* TARGET_FF_MORPHO */
DigitalInOut rfsw(A4);
void Radio::rfsw_callback()
{
    if (radio.RegOpMode.bits.Mode == RF_OPMODE_TRANSMITTER)
        rfsw = 1;
    else
        rfsw = 0;

#ifdef TARGET_FF_MORPHO
    if (radio.RegOpMode.bits.Mode == RF_OPMODE_RECEIVER || radio.RegOpMode.bits.Mode == RF_OPMODE_RECEIVER_SINGLE)
        pc3 = 1;
    else
        pc3 = 0;
#endif /* TARGET_FF_MORPHO */
}

void Radio::targetInit()
{
    radio.rf_switch = rfsw_callback;

    rfsw.input();

    radio.RegPaConfig.octet = radio.read_reg(REG_PACONFIG);

    if (rfsw.read()) {
        shield_type = SHIELD_TYPE_LAS;
        radio.RegPaConfig.bits.PaSelect = 1;
    } else {
        shield_type = SHIELD_TYPE_MAS;
        radio.RegPaConfig.bits.PaSelect = 0;
    }

    radio.write_reg(REG_PACONFIG, radio.RegPaConfig.octet);

    rfsw.output();
}

void Radio::tx_dbm_print()
{
    int dbm;
    RegPdsTrim1_t pds_trim;
    uint8_t adr, pa_test_adr;

    if (radio.type == SX1276) {
        adr = REG_PDSTRIM1_SX1276;
        pa_test_adr = REG_PATEST_SX1276;
    } else {
        adr = REG_PDSTRIM1_SX1272;
        pa_test_adr = REG_PATEST_SX1272;
    }

    if (radio.read_reg(pa_test_adr) & 0x20) {
        pds_trim.octet = radio.read_reg(adr);

        radio.RegPaConfig.octet = radio.read_reg(REG_PACONFIG);
        if (radio.RegPaConfig.bits.PaSelect) {
            dbm = radio.RegPaConfig.bits.OutputPower + pds_trim.bits.prog_txdac - 2;
        } else {
            dbm = radio.RegPaConfig.bits.OutputPower - 1;
        }
    } else {
        dbm = PA_OFF_DBM;
    }
    printf("%d", dbm);
}

bool Radio::tx_dbm_write(const char* str)
{
    int i;
    uint8_t v, adr, pa_test_adr;
    RegPdsTrim1_t pds_trim;

    sscanf(str, "%d", &i);

    if (radio.type == SX1276) {
        adr = REG_PDSTRIM1_SX1276;
        pa_test_adr = REG_PATEST_SX1276;
    } else {
        adr = REG_PDSTRIM1_SX1272;
        pa_test_adr = REG_PATEST_SX1272;
    }

    v = radio.read_reg(pa_test_adr);

    if (i == PA_OFF_DBM) {
        /* for bench testing: prevent overloading receiving station (very low TX power) */
        v &= ~0x20; // turn off pu_regpa_n: disable PA
        radio.write_reg(pa_test_adr, v);
        return false;
    } else if ((v & 0x20) == 0) {
        v |= 0x20; // turn on pu_regpa_n: enable PA
        radio.write_reg(pa_test_adr, v);
    }

    pds_trim.octet = radio.read_reg(adr);

    if (radio.RegPaConfig.bits.PaSelect) {
        /* PABOOST used: +2dbm to +17, or +20 */
        if (i == 20) {
            log_printf("+20dBm PADAC bias\r\n");
            i -= 3;
            pds_trim.bits.prog_txdac = 7;
            radio.write_reg(adr, pds_trim.octet);
        }
        if (i > 1)
                radio.RegPaConfig.bits.OutputPower = i - 2;
    } else {
        /* RFO used: -1 to +14dbm */
        if (i < 15)
            radio.RegPaConfig.bits.OutputPower = i + 1;
    }
    radio.write_reg(REG_PACONFIG, radio.RegPaConfig.octet);

    return false;
}


#endif /* ..SX127x_H */
#endif /* ...sx127x shield */

