#include "radio.h"

#define RADIO_RESET              PC_2 //NorAm_Mote Reset_sx
#define RADIO_MOSI               PB_15 //NorAm_Mote SPI2 Mosi
#define RADIO_MISO               PB_14 //NorAm_Mote SPI2 Miso
#define RADIO_SCLK               PB_13 //NorAm_Mote  SPI2 Clk
#define RADIO_NSS                PB_12 //NorAm_Mote SPI2 Nss
 
#define RADIO_DIO_0              PC_6 //NorAm_Mote DIO0 
#define RADIO_DIO_1              PC_10 //NorAm_Mote DIO1 
#define RADIO_DIO_2              PC_8 //NorAm_Mote DIO2 
#define RADIO_DIO_3              PB_4 //NorAm_Mote DIO3 
#define RADIO_DIO_4              PB_5 //NorAm_Mote DIO4 
#define RADIO_DIO_5              PB_6 //NorAm_Mote DIO5
 
#define RFSW1                    PC_4 //NorAm_Mote RFSwitch_CNTR_1
#define RFSW2                    PC_13 //NorAm_Mote RFSwitch_CNTR_2

SPI spi(RADIO_MOSI, RADIO_MISO, RADIO_SCLK); // mosi, miso, sclk
//                   dio0, dio1, nss, spi, rst
SX127x Radio::radio(RADIO_DIO_0, RADIO_DIO_1, RADIO_NSS, spi, RADIO_RESET); 
SX127x_lora Radio::lora(radio);
SX127x_fsk Radio::fsk(radio);

DigitalOut rfsw1(RFSW1);
DigitalOut rfsw2(RFSW2);

DigitalOut red(LED1);
DigitalOut yellow(LED3);
#define LED_OFF     1
#define LED_ON      0

void Radio::rfsw_callback()
{
    if (radio.RegOpMode.bits.Mode == RF_OPMODE_TRANSMITTER) {  // start of transmission
        red = LED_ON;
        yellow = LED_OFF;
        if (radio.HF) {
            if (radio.RegPaConfig.bits.PaSelect) { // if PA_BOOST
                rfsw2 = 0;
                rfsw1 = 1;
            } else { // RFO to power amp
                rfsw2 = 1;
                rfsw1 = 0;
            }
        } else {
            // todo: sx1276
        }
    } else if (radio.RegOpMode.bits.Mode == RF_OPMODE_RECEIVER || radio.RegOpMode.bits.Mode == RF_OPMODE_RECEIVER_SINGLE || radio.RegOpMode.bits.Mode == RF_OPMODE_CAD) { // start of reception
        red = LED_OFF;
        yellow = LED_ON;
        if (radio.HF) {
            rfsw2 = 1;
            rfsw1 = 1;
        } else {
            // todo: sx1276
        }
    } else { // RF switch shutdown
        yellow = LED_OFF;
        red = LED_OFF;
        rfsw2 = 0;
        rfsw1 = 0;
    }
}

void Radio::tx_dbm_print()
{
    int dbm;
    uint8_t adr, pa_test_adr;

    if (radio.type == SX1276) {
        adr = REG_PDSTRIM1_SX1276;
        pa_test_adr = REG_PATEST_SX1276;
    } else {
        adr = REG_PDSTRIM1_SX1272;
        pa_test_adr = REG_PATEST_SX1272;
    }

    if (radio.read_reg(pa_test_adr) & 0x20) {
        radio.RegPaConfig.octet = radio.read_reg(REG_PACONFIG);
        if (radio.RegPaConfig.bits.PaSelect) {
            RegPdsTrim1_t pds_trim;

            pds_trim.octet = radio.read_reg(adr);
            dbm = radio.RegPaConfig.bits.OutputPower + pds_trim.bits.prog_txdac - 2;
        } else {
            dbm = radio.RegPaConfig.bits.OutputPower - 21;
        }
    } else
        dbm = PA_OFF_DBM;

    pc.printf(":%d", dbm);
}

bool Radio::tx_dbm_write(const char* str)
{
    int dbm;

    sscanf(str, "%d", &dbm);

    if (dbm > 20) {
        radio.RegPaConfig.bits.PaSelect = 0;    // RFO to external amplifier
        dbm -= 20;
        if (dbm < 15)
            radio.RegPaConfig.bits.OutputPower = dbm + 1;
    } else {
        uint8_t adr;
        RegPdsTrim1_t pds_trim;

        radio.RegPaConfig.bits.PaSelect = 1;    // PA_BOOST
        /* PABOOST used: +2dbm to +17, or +20 */

        if (radio.type == SX1276)
            adr = REG_PDSTRIM1_SX1276;
        else
            adr = REG_PDSTRIM1_SX1272;

        pds_trim.octet = radio.read_reg(adr);
        if (dbm > 17) {
            dbm -= 3;
            pds_trim.bits.prog_txdac = 7;
            radio.write_reg(adr, pds_trim.octet);
        }

        if (dbm > 1)
            radio.RegPaConfig.bits.OutputPower = dbm - 2;
    }

    radio.write_reg(REG_PACONFIG, radio.RegPaConfig.octet);

    return false;
}

void Radio::targetInit()
{
    radio.rf_switch = rfsw_callback;
}
