#include "mbed.h"

//------------------------------------
// Hyperterminal configuration
// 9600 bauds, 8-bit data, no parity
// UART RX overrun: Type in characters quickly to see if program freezes
//------------------------------------

Serial pc(USBTX, USBRX);

DigitalOut myled(LED1);

void rx_cb()
{
    int i;

    pc.putc(pc.getc()); // echo
    myled = 1;

    /* delay is very bad action here,
     * but purpose is to create a UART RX overrun */
    for (i = 0; i < 0x20000; i++)
        __nop();    

    myled = 0;
}
 
int main()
{
    pc.printf("\r\nstart\r\n");
    pc.attach(&rx_cb);

    while(1) { 
        __nop();
    }
}
