#include "radio.h"
#include "LPS22HBSensor.h"

#ifndef TARGET_DISCO_L072CZ_LRWAN1
    #error only_for_L072CZ_discovery
#endif

#define BW_KHZ              125
#define SPREADING_FACTOR    7
#define CF_HZ               915000000
#define TX_DBM              20

/*
DevI2C devI2c(I2C_SDA, I2C_SCL);
LPS22HBSensor press_temp(&devI2c);
*/
AnalogIn pa0(PA_0);
DigitalIn test_in_pin(PB_5, PullDown);
DigitalOut ext_led(PB_2);
#define EXT_LED_ON      0
#define EXT_LED_OFF     1


/**********************************************************************/
volatile bool txDone;

void txDoneCB()
{
    txDone = true;
}

void rxDoneCB(uint8_t size, float rssi, float snr)
{
}

const RadioEvents_t rev = {
    /* Dio0_top_half */     NULL,
    /* TxDone_topHalf */    NULL,
    /* TxDone_botHalf */    txDoneCB,
    /* TxTimeout  */        NULL,
    /* RxDone  */           rxDoneCB,
    /* RxTimeout  */        NULL,
    /* RxError  */          NULL,
    /* FhssChangeChannel  */NULL,
    /* CadDone  */          NULL
};

int main()
{
    printf("\r\nreset-tx ");

    Radio::Init(&rev);

    Radio::Standby();
    Radio::LoRaModemConfig(BW_KHZ, SPREADING_FACTOR, 1);
    Radio::SetChannel(CF_HZ);

    Radio::set_tx_dbm(TX_DBM);

               // preambleLen, fixLen, crcOn, invIQ
    Radio::LoRaPacketConfig(8, false, true, false);

    for (;;) {

        uint16_t samp = pa0.read_u16();
        if (test_in_pin) {
            ext_led = EXT_LED_ON;
            printf("continuous-tx\r\n");
#ifdef SX127x_H
            Radio::radio.set_opmode(RF_OPMODE_SLEEP);
            Radio::fsk.enable(false);
            Radio::radio.write_u16(REG_FSK_FDEVMSB, 0);
            Radio::radio.write_u16(REG_FSK_PREAMBLEMSB, 0xffff);
            Radio::fsk.start_tx(8);
#else
    #error tx_carrier
#endif /* SX127x_H*/
        }

        ext_led = EXT_LED_ON;
        Radio::radio.tx_buf[0] = samp;
        samp >>= 8;
        Radio::radio.tx_buf[1] = samp;
        txDone = false;
        Radio::Send(2, 0, 0, 0);   /* begin transmission */

        printf("Sent %04x\r\n", samp);
        while (!txDone) {
            Radio::service();
        }
        printf("got-tx-done\r\n");
        ext_led = EXT_LED_OFF;

        wait(1.0);  /* throttle sending rate */
    }
}

