#include "main.h"
#if (GEOLOCATION_PROVIDER == GOOGLE)
#include "radio.h"

const char GOOGLE_SSL_CA_PEM[] = "-----BEGIN CERTIFICATE-----\n"
"MIIDujCCAqKgAwIBAgILBAAAAAABD4Ym5g0wDQYJKoZIhvcNAQEFBQAwTDEgMB4G\n"
"A1UECxMXR2xvYmFsU2lnbiBSb290IENBIC0gUjIxEzARBgNVBAoTCkdsb2JhbFNp\n"
"Z24xEzARBgNVBAMTCkdsb2JhbFNpZ24wHhcNMDYxMjE1MDgwMDAwWhcNMjExMjE1\n"
"MDgwMDAwWjBMMSAwHgYDVQQLExdHbG9iYWxTaWduIFJvb3QgQ0EgLSBSMjETMBEG\n"
"A1UEChMKR2xvYmFsU2lnbjETMBEGA1UEAxMKR2xvYmFsU2lnbjCCASIwDQYJKoZI\n"
"hvcNAQEBBQADggEPADCCAQoCggEBAKbPJA6+Lm8omUVCxKs+IVSbC9N/hHD6ErPL\n"
"v4dfxn+G07IwXNb9rfF73OX4YJYJkhD10FPe+3t+c4isUoh7SqbKSaZeqKeMWhG8\n"
"eoLrvozps6yWJQeXSpkqBy+0Hne/ig+1AnwblrjFuTosvNYSuetZfeLQBoZfXklq\n"
"tTleiDTsvHgMCJiEbKjNS7SgfQx5TfC4LcshytVsW33hoCmEofnTlEnLJGKRILzd\n"
"C9XZzPnqJworc5HGnRusyMvo4KD0L5CLTfuwNhv2GXqF4G3yYROIXJ/gkwpRl4pa\n"
"zq+r1feqCapgvdzZX99yqWATXgAByUr6P6TqBwMhAo6CygPCm48CAwEAAaOBnDCB\n"
"mTAOBgNVHQ8BAf8EBAMCAQYwDwYDVR0TAQH/BAUwAwEB/zAdBgNVHQ4EFgQUm+IH\n"
"V2ccHsBqBt5ZtJot39wZhi4wNgYDVR0fBC8wLTAroCmgJ4YlaHR0cDovL2NybC5n\n"
"bG9iYWxzaWduLm5ldC9yb290LXIyLmNybDAfBgNVHSMEGDAWgBSb4gdXZxwewGoG\n"
"3lm0mi3f3BmGLjANBgkqhkiG9w0BAQUFAAOCAQEAmYFThxxol4aR7OBKuEQLq4Gs\n"
"J0/WwbgcQ3izDJr86iw8bmEbTUsp9Z8FHSbBuOmDAGJFtqkIk7mpM0sYmsL4h4hO\n"
"291xNBrBVNpGP+DTKqttVCL1OmLNIG+6KYnX3ZHu01yiPqFbQfXf5WRDLenVOavS\n"
"ot+3i9DAgBkcRcAtjOj4LaR0VknFBbVPFd5uRHg5h6h+u/N5GJG79G+dwfCMNYxd\n"
"AfvDbbnvRG15RjF+Cv6pgsH/76tuIMRQyV+dTZsXjAzlAcmgQWpzU/qlULRuJQ/7\n"
"TBj0/VLZjmmx6BEP3ojY+x1J96relc8geMJgEtslQIxq/H5COEBkEveegeGTLg==\n"
"-----END CERTIFICATE-----\n";

char my_copy[128];

/* parse_json: get result sent from server */
void parse_json(const char *body, float *lat, float *lng, int *accuracy)
{
    bool in_location = false;
    bool get_lat = false;
    bool get_lng = false;
    bool get_accuracy = false;
    unsigned n;
    strncpy(my_copy, body, sizeof(my_copy));
    strtok(my_copy, "\"");
    for (n = 0; n < 10; n++) {
        char *t = strtok(NULL, "\":");
        if (!t)
            break;
        if (in_location) {
            if (get_lat) {
                sscanf(t, "%f", lat);
                get_lat = false;
            } else if (get_lng) {
                sscanf(t, "%f", lng);
                get_lng = false;
            }
            if (strchr(t, '}'))
                in_location = false;
            else if (strcmp(t, "lat") == 0)
                get_lat = true;
            else if (strcmp(t, "lng") == 0)
                get_lng = true;
        } else {
            if (get_accuracy) {
                sscanf(t, "%d", accuracy);
                get_accuracy = false;
            }
            if (strcmp(t, "location") == 0)
                in_location = true;
            else if (strcmp(t, "accuracy") == 0)
                get_accuracy = true;
        }
    }
}

/*
 * https://developers.google.com/maps/documentation/geolocation/overview
 */
int post_scan_result(const char *body, float *lat, float *lng, int *accuracy)
{
    HttpsRequest* post_req = new HttpsRequest(network, GOOGLE_SSL_CA_PEM, HTTP_POST, "https://www.googleapis.com/geolocation/v1/geolocate?key=YOUR-API-KEY");

    post_req->set_header("Content-Type", "application/json");

    HttpResponse* post_res = post_req->send(body, strlen(body));
    if (!post_res) {
        printf("HttpRequest failed (error code %d)\n", post_req->get_error());
        return -1;
    }

    dump_response(post_res);
    parse_json(post_res->get_body_as_string().c_str(), lat, lng, accuracy);
    delete post_req;

    return 0;
}

void json_start()
{
    strcpy(json, "{\"considerIp\": \"false\",");
    strcat(json, "\"wifiAccessPoints\": [");
}

void json_end()
{
    strcat(json, "]");
    strcat(json, "}");
}

void wifi_result_to_json(bool first, const uint8_t *result, unsigned macStart, unsigned rssi_idx)
{
    char str[8];
    unsigned i;

    if (!first)
        strcat(json, ",");  // end previous wifiAccessPoint

    strcat(json, "{\"macAddress\": \"");
    for (i = 0; i < 6; i++) {
        sprintf(str, "%02x", result[i + macStart]);
        strcat(json, str);
        if (i < 5)
            strcat(json, ":");
    }
    strcat(json, "\",\"signalStrength\": ");
    sprintf(str, "%d", (int8_t)result[rssi_idx]);
    strcat(json, str);
    strcat(json, ",\"signalToNoiseRatio\": 0");

    strcat(json, "}");
}

#endif /* GEOLOCATION_PROVIDER == GOOGLE */
