#include "main.h"
#ifdef ANALOG_TRIGGER

#define NUM_ANALOG_IN       4

#if defined(TARGET_FF_MORPHO) && defined(TARGET_FAMILY_STM32)
PinName pin_names[NUM_ANALOG_IN] = {
    PC_2, /* CN7-35 */
    PC_3, /* CN7-37 */
    PC_4, /* CN10-34 */
    PC_5  /* CN10-6 */
};
#endif

const uint8_t rfCmds[NUM_ANALOG_IN] = {
    CMD_PWM_A,
    CMD_PWM_B,
    CMD_PWM_C,
    CMD_PWM_D
};

typedef struct {
    AnalogIn* ain;
    uint16_t prev;
    int8_t movement;
    bool sent;
} analog_t;

analog_t _a_[NUM_ANALOG_IN];

void trigger_init()
{
    unsigned n;
    for (n = 0; n < NUM_ANALOG_IN; n++) {
        _a_[n].ain = new AnalogIn(pin_names[n]);
        _a_[n].prev = _a_[n].ain->read_u16();
        _a_[n].movement = 0;
        _a_[n].sent = false;
    }
}

#define AIN_REST_THRESHOLD      96  // 12bit left justified

void analog_mainloop(analog_t* ana, uint8_t rfCmd)
{
    uint16_t ain = ana->ain->read_u16();
    uint16_t diff = abs(ain-ana->prev);
    if (diff > AIN_REST_THRESHOLD) {
        ana->sent = false;
        if (ana->movement < 1)
            ana->movement = 1;
        else {
            if (++ana->movement > 16)
                ana->movement = 16;
        }
    } else {
        /* steady state */
        if (ana->movement > 0)
            ana->movement = 0;
        else {
            if (--ana->movement < -16) {
                ana->movement = -16;
                if (!ana->sent) {
                    uint8_t buf[4];
                    printf("## %02x ##\r\n", ain >> 8);
                    buf[0] = rfCmd;
                    buf[1] = 120;   // Hz
                    buf[2] = ain >> 8;  // duty
                    radio_tx(buf, 3);
                    ana->sent = true;
                }
            }
        }
    }
    //printf("%05u  diff:%04u  move:%d\r\n", ain, diff, ain_movement);
    ana->prev = ain;
}

void trigger_mainloop()
{
    unsigned n;
    for (n = 0; n < NUM_ANALOG_IN; n++) {
        analog_mainloop(&_a_[n], rfCmds[n]);
    }
    wait_us(5000);
}

#endif /* ANALOG_TRIGGER */
