#include "main.h"
#ifdef DIGITAL_TRIGGER

Ticker ticker;
InterruptIn user_button(USER_BUTTON);

DigitalOut jumper_out(PC_10);
InterruptIn jumper_in(PC_12);
volatile bool start_tx;

volatile bool jin;
uint8_t out_pin_state;

void button_isr()
{
    if (!jumper_in.read())
        start_tx = true;
}

void auto_tx()
{
    if (jumper_in.read())
        start_tx = true;
    else
        ticker.detach();
}

void trigger_init()
{
    jin = false;

    jumper_out = 1;
    jumper_in.mode(PullDown);

    while (!user_button) {
        printf("button-lo\r\n");
        wait(0.01);
    }
    user_button.fall(&button_isr);
}

void trigger_mainloop()
{
    if (jumper_in.read()) {
        if (!jin) {
            ticker.attach(auto_tx, 0.5);
            jin = true;
        }
    } else {
        jin = false;
    }

    if (start_tx) {
        start_tx = false;

        uint8_t buf[2];
        out_pin_state ^= 1;
        buf[0] = CMD_OUT_PIN;
        buf[1] = out_pin_state;
        radio_tx(buf, 2);
    }
}

#endif /* DIGITAL_TRIGGER */

