#include "lorachip.h"
#ifdef SX127x_H

#if defined(TARGET_FF_ARDUINO) && defined(TARGET_FF_MORPHO) && !defined(TARGET_DISCO_L072CZ_LRWAN1)
void tx_dbm_print()
{
    int dbm;
    RegPdsTrim1_t pds_trim;
    uint8_t adr, pa_test_adr;

    if (Radio::radio.type == SX1276) {
        adr = REG_PDSTRIM1_SX1276;
        pa_test_adr = REG_PATEST_SX1276;
    } else {
        adr = REG_PDSTRIM1_SX1272;
        pa_test_adr = REG_PATEST_SX1272;
    }

    if (Radio::radio.read_reg(pa_test_adr) & 0x20) {
        pds_trim.octet = Radio::radio.read_reg(adr);

        Radio::radio.RegPaConfig.octet = Radio::radio.read_reg(REG_PACONFIG);
        if (Radio::radio.RegPaConfig.bits.PaSelect) {
            dbm = Radio::radio.RegPaConfig.bits.OutputPower + pds_trim.bits.prog_txdac - 2;
        } else {
            dbm = Radio::radio.RegPaConfig.bits.OutputPower - 1;
        }
    } else {
        dbm = PA_OFF_DBM;
    }
    pc.printf("%ddBm ", dbm);
}
#endif /* ...sx127x shield */

static const float lora_bws_1276[] = {
    7.8, // 0
    10.4, // 1
    15.6, // 2
    20.8, // 3
    31.25, // 4
    41.7, // 5
    62.5, // 6
    125, // 7
    250, // 8
    500 // 9
};

static const float lora_bws_1272[] = {
    125, // 0
    250, // 1
    500 // 2
};

void printLoraIrqs(bool clear)
{
    //in radio class -- RegIrqFlags_t RegIrqFlags;
 
    //already read RegIrqFlags.octet = radio.read_reg(REG_LR_IRQFLAGS);
    pc.printf("\r\nIrqFlags:");
    if (Radio::lora.RegIrqFlags.bits.CadDetected)
        pc.printf("CadDetected ");
    if (Radio::lora.RegIrqFlags.bits.FhssChangeChannel) {
        //radio.RegHopChannel.octet = radio.read_reg(REG_LR_HOPCHANNEL);
        pc.printf("FhssChangeChannel:%d ", Radio::lora.RegHopChannel.bits.FhssPresentChannel);
    }
    if (Radio::lora.RegIrqFlags.bits.CadDone)
        pc.printf("CadDone ");
    if (Radio::lora.RegIrqFlags.bits.TxDone)
        pc.printf("TxDone ");
    if (Radio::lora.RegIrqFlags.bits.ValidHeader)
        pc.printf("[42mValidHeader[0m ");
    if (Radio::lora.RegIrqFlags.bits.PayloadCrcError)
        pc.printf("[41mPayloadCrcError[0m ");
    if (Radio::lora.RegIrqFlags.bits.RxDone)
        pc.printf("[42mRxDone[0m ");  
    if (Radio::lora.RegIrqFlags.bits.RxTimeout)
        pc.printf("RxTimeout ");
 
    pc.printf("\r\n");
 
    if (clear)
        Radio::radio.write_reg(REG_LR_IRQFLAGS, Radio::lora.RegIrqFlags.octet);
 
}

void print_lora_status()
{
    float MHz;
    const float* bws;
    unsigned bw_idx;

    tx_dbm_print();
    Radio::radio.RegOpMode.octet = Radio::radio.read_reg(REG_OPMODE);

    switch (Radio::radio.RegOpMode.bits.Mode) {
        case 0: pc.printf("SLEEP"); break;
        case 1: pc.printf("STANDBY"); break;
        case 2: pc.printf("FS_TX"); break;
        case 3: pc.printf("TX"); break;
        case 4: pc.printf("FS_RX"); break;
        case 5: pc.printf("RX"); break;
        case 6: pc.printf("RX_SINGLE"); break;
        case 7: pc.printf("CAD"); break;
    }

    Radio::lora.RegIrqFlags.octet = Radio::radio.read_reg(REG_LR_IRQFLAGS);
    printLoraIrqs(false);

    if (Radio::radio.type == SX1276)
        bws = lora_bws_1276;
    else if (Radio::radio.type == SX1272)
        bws = lora_bws_1272;
    else
        return;
    
    bw_idx = Radio::lora.getBw();
    pc.printf("sf%u %.1fKHz ", Radio::lora.getSf(), bws[bw_idx]);
    MHz = Radio::radio.get_frf_MHz();
    pc.printf(" %.3fMHz\r\n", MHz);

}

void cmd_sf(uint8_t argsAt)
{
    unsigned sf;

    if (sscanf(pcbuf + argsAt, "%u", &sf) == 1) {
        Radio::lora.setSf(sf);
        current.sf = sf;
        set_symb_timeout();
    }

    pc.printf("sf%u\r\n", Radio::lora.getSf());
}

void cmd_frf(uint8_t argsAt)
{
    float MHz;

    if (sscanf(pcbuf + argsAt, "%f", &MHz) == 1) {
        Radio::radio.set_frf_MHz(MHz);
    }
    MHz = Radio::radio.get_frf_MHz();
    pc.printf("%.3fMHz\r\n", MHz);
}

void cmd_bw(uint8_t argsAt)
{
    const float* bws;
    unsigned khz;
    unsigned bw_idx;

    if (sscanf(pcbuf + argsAt, "%u", &khz) == 1) {
        Radio::Standby();
        wait(0.02);

        Radio::lora.setBw_KHz(khz);

        wait(0.02);
        Radio::Rx(0);

        current.bwKHz = khz;
        set_symb_timeout();
    }

    if (Radio::radio.type == SX1276)
        bws = lora_bws_1276;
    else if (Radio::radio.type == SX1272)
        bws = lora_bws_1272;
    else
        return;

    bw_idx = Radio::lora.getBw();
    pc.printf("%.1fKHz\r\n", bws[bw_idx]);
}

void radio_readChip()
{
}

#endif /* SX127x_H */
