#include "lorachip.h"
#ifdef SX126x_H

PacketParams_t ppLORA;
ModulationParams_t mpLORA;
uint8_t tx_param_buf[2];
uint8_t pa_config_buf[4];

void tx_dbm_print()
{
    PwrCtrl_t PwrCtrl;
    PaCtrl1b_t PaCtrl1b;
    unsigned v = Radio::radio.readReg(REG_ADDR_ANACTRL16, 1);

    if (v & 0x10) {
        pc.printf("%d", PA_OFF_DBM);
        return;
    }

    PwrCtrl.octet = Radio::radio.readReg(REG_ADDR_PWR_CTRL, 1);

    PaCtrl1b.octet = Radio::radio.readReg(REG_ADDR_PA_CTRL1B, 1);
    pa_config_buf[2] = PaCtrl1b.bits.tx_mode_bat;   // deviceSel

    pc.printf("%ddBm ", PwrCtrl.bits.tx_pwr - (PaCtrl1b.bits.tx_mode_bat ? 17 : 9));
}

void cmd_frf(uint8_t argsAt)
{
    float MHz;

    if (sscanf(pcbuf + argsAt, "%f", &MHz) == 1) {
        Radio::radio.setMHz(MHz);
    }
    MHz = Radio::radio.getMHz();
    pc.printf("%.3fMHz\r\n", MHz);
}

const uint8_t loraBWs[] = {
    LORA_BW_7, LORA_BW_10, LORA_BW_15,
    LORA_BW_20, LORA_BW_31, LORA_BW_41,
    LORA_BW_62, LORA_BW_125, LORA_BW_250,
    LORA_BW_500
};

static const float lora_bws[] = {
    7.81, 10.42, 15.63,
    20.83, 31.25, 41.67,
    62.5, 125, 250,
    500,
    0
};

void print_lora_status()
{
    status_t status;
    float MHz;
    unsigned n;
    loraConfig0_t conf0;

    tx_dbm_print();
    Radio::radio.xfer(OPCODE_GET_STATUS, 0, 1, &status.octet);

    pc.printf(" ");
    /* translate opmode_status_strs to opmode_select_strs */
    switch (status.bits.chipMode) {
        case 2: pc.printf("STBY_RC"); break; // STBY_RC
        case 3: pc.printf("STBY_XOSC"); break; // STBY_XOSC
        case 4: pc.printf("FS"); break; // FS
        case 5: pc.printf("RX"); break; // RX
        case 6: pc.printf("TX"); break; // TX
        default: pc.printf("<%d>", status.bits.chipMode); break;
    }
    pc.printf("\t");

    conf0.octet = Radio::radio.readReg(REG_ADDR_LORA_CONFIG0, 1);
    mpLORA.lora.bandwidth = conf0.bits.modem_bw;
    for (n = 0; n < sizeof(loraBWs); n++) {
        if (conf0.bits.modem_bw == loraBWs[n]) {
            pc.printf("%.1fKHz ", lora_bws[n]);
        }
    }
    mpLORA.lora.spreadingFactor = conf0.bits.modem_sf;
    pc.printf("sf%u ", conf0.bits.modem_sf);

    MHz = Radio::radio.getMHz();
    pc.printf(" %.3fMHz\r\n", MHz);
}

void cmd_sf(uint8_t argsAt)
{
    loraConfig0_t conf0;
    unsigned sf;

    if (sscanf(pcbuf + argsAt, "%u", &sf) == 1) {
        mpLORA.lora.spreadingFactor = sf;
        Radio::radio.xfer(OPCODE_SET_MODULATION_PARAMS, 4, 0, mpLORA.buf);

        current.sf = sf;
        set_symb_timeout();
    }

    conf0.octet = Radio::radio.readReg(REG_ADDR_LORA_CONFIG0, 1);
    mpLORA.lora.spreadingFactor = conf0.bits.modem_sf;
    pc.printf("sf%u\r\n", conf0.bits.modem_sf);
}

void cmd_bw(uint8_t argsAt)
{
    unsigned n;
    float khz;
    loraConfig0_t conf0;

    if (sscanf(pcbuf + argsAt, "%f", &khz) == 1) {
        int sidx = -1;
        float min_diff = 9999;
        Radio::Standby();
        wait(0.02);

        for (n = 0; lora_bws[n] > 0; n++) {
            float diff = fabs(lora_bws[n] - khz);
            if (diff < min_diff) {
                sidx = n;
                min_diff = diff;
            }
        }
        if (sidx == -1) {
            pc.printf("bw not found\r\n");
            return;
        }

        mpLORA.lora.bandwidth = loraBWs[sidx];
        Radio::radio.xfer(OPCODE_SET_MODULATION_PARAMS, 4, 0, mpLORA.buf);
        
        wait(0.02);
        set_symb_timeout();
        Radio::Rx(0);

        current.bwKHz = khz;
    }

    conf0.octet = Radio::radio.readReg(REG_ADDR_LORA_CONFIG0, 1);
    mpLORA.lora.bandwidth = conf0.bits.modem_bw;
    for (n = 0; n < sizeof(loraBWs); n++) {
        if (conf0.bits.modem_bw == loraBWs[n]) {
            pc.printf("%.1fKHz\r\n", lora_bws[n]);
            break;
        }
    }
}

void radio_readChip()
{
#if 0
    bwSel_t bwSel;
    shapeCfg_t shapeCfg;
    unsigned d = radio.readReg(REG_ADDR_BITRATE, 3);
    pc.printf("%06x:%u->", d ,d);
    pc.printf("bitrate %ubps\r\n", (32 * XTAL_FREQ_HZ) / d);
    mpFSK.gfsk.bitrateHi = d >> 16;
    mpFSK.gfsk.bitrateMid = d >> 8;
    mpFSK.gfsk.bitrateLo = d;

    d = radio.readReg(REG_ADDR_FREQDEV, 3);
    pc.printf("fdev %fKHz\r\n", d / KHZ_TO_FRF);
    mpFSK.gfsk.fdevHi = d >> 16;
    mpFSK.gfsk.fdevMid = d >> 8;
    mpFSK.gfsk.fdevLo = d;

    shapeCfg.octet = radio.readReg(REG_ADDR_SHAPECFG, 1);
    mpFSK.gfsk.PulseShape = shapeCfg.octet;

    bwSel.octet = radio.readReg(REG_ADDR_BWSEL, 1);
    // GFSK_RX_BW_*
    pc.printf("bwsSel:%02x\r\n", bwSel.octet);
    mpFSK.gfsk.bandwidth = bwSel.octet;

    {
        unsigned n = radio.readReg(REG_ADDR_FSK_PREAMBLE_TXLEN , 2);
        ppFSK.gfsk.PreambleLengthHi = n << 8; // param1
        ppFSK.gfsk.PreambleLengthLo = n;// param2
    }

    {
        pktCtrl1_t pktCtrl1;
        pktCtrl1.octet = radio.readReg(REG_ADDR_FSK_PKTCTRL1, 1);
        ppFSK.gfsk.PreambleDetectorLength = pktCtrl1.octet & 0x07;    // param3
    }


    ppFSK.gfsk.SyncWordLength = radio.readReg(REG_ADDR_FSK_SYNC_LEN, 1);// param4
    ppFSK.gfsk.AddrComp = radio.readReg(REG_ADDR_NODEADDRCOMP, 1);// param5

    {
        pktCtrl0_t pktCtrl0;
        pktCtrl0.octet = radio.readReg(REG_ADDR_FSK_PKTCTRL0, 1);
        ppFSK.gfsk.PacketType = pktCtrl0.bits.pkt_len_format;   // param6
    }

    ppFSK.gfsk.PayloadLength = radio.readReg(REG_ADDR_FSK_PAYLOAD_LEN, 1);// param7

    {
        pktCtrl2_t pktCtrl2;
        pktCtrl2.octet = radio.readReg(REG_ADDR_FSK_PKTCTRL2, 1);
        ppFSK.gfsk.CRCType = pktCtrl2.octet & 0x7; // param8
        ppFSK.gfsk.Whitening = pktCtrl2.bits.whit_enable;   // param9
    }
#endif /* if 0 */

    /*******************************/

    {
        loraConfig0_t conf0;
        conf0.octet = Radio::radio.readReg(REG_ADDR_LORA_CONFIG0, 1);
        pc.printf("LoRa bw%u sf%u ", conf0.bits.modem_bw, conf0.bits.modem_sf);
        mpLORA.lora.spreadingFactor = conf0.bits.modem_sf;
        mpLORA.lora.bandwidth = conf0.bits.modem_bw;
    }

    {
        loraConfig1_t conf1;
        conf1.octet = Radio::radio.readReg(REG_ADDR_LORA_CONFIG1, 1);
        mpLORA.lora.LowDatarateOptimize = conf1.bits.ppm_offset;
        ppLORA.lora.HeaderType = conf1.bits.implicit_header;
        ppLORA.lora.InvertIQ = conf1.bits.rx_invert_iq;
        mpLORA.lora.codingRate = conf1.bits.tx_coding_rate;
    }

    {
        loraConfig2_t conf2;
        conf2.octet = Radio::radio.readReg(REG_ADDR_LORA_CONFIG2, 1);
        ppLORA.lora.CRCType = conf2.bits.tx_payload_crc16_en;
    }

    {
        uint32_t val = Radio::radio.readReg(REG_ADDR_LORA_PREAMBLE_SYMBNB, 2);
        ppLORA.lora.PreambleLengthHi = val >> 8;
        ppLORA.lora.PreambleLengthLo = val;
    }

    {
        AnaCtrl6_t AnaCtrl6;
        AnaCtrl7_t AnaCtrl7;
        PaCtrl1b_t PaCtrl1b;

        AnaCtrl6.octet = Radio::radio.readReg(REG_ADDR_ANACTRL6, 1);
        pa_config_buf[0] = AnaCtrl6.bits.pa_dctrim_select_ana;  // paDutyCycle

        AnaCtrl7.octet = Radio::radio.readReg(REG_ADDR_ANACTRL7, 1);
        pa_config_buf[1] = AnaCtrl7.bits.pa_hp_sel_ana; // hpMax

        PaCtrl1b.octet = Radio::radio.readReg(REG_ADDR_PA_CTRL1B, 1);
        pa_config_buf[2] = PaCtrl1b.bits.tx_mode_bat;   // deviceSel

        pa_config_buf[3] = 1;   // paLut
    }

/*    {
        cadParams[0] = radio.readReg(REG_ADDR_LORA_CONFIG9, 1);
        cadParams[0] >>= 5;

        cadParams[1] = radio.readReg(REG_ADDR_LORA_CAD_PN_RATIO, 1);
        cadParams[2] = radio.readReg(REG_ADDR_LORA_CAD_MINPEAK, 1);
    }*/
}

#endif /* SX126x_H */
