#include "mbed.h"


#define SX9500_REG_IRQSRC                           0x00
#define SX9500_REG_STAT                             0x01
#define SX9500_REG_IRQMSK                           0x03
#define SX9500_REG_PROXCTRL0                        0x06
#define SX9500_REG_PROXCTRL1                        0x07
#define SX9500_REG_PROXCTRL2                        0x08
#define SX9500_REG_PROXCTRL3                        0x09
#define SX9500_REG_PROXCTRL4                        0x0A
#define SX9500_REG_PROXCTRL5                        0x0B
#define SX9500_REG_PROXCTRL6                        0x0C
#define SX9500_REG_PROXCTRL7                        0x0D
#define SX9500_REG_PROXCTRL8                        0x0E
#define SX9500_REG_SENSORSEL                        0x20
#define SX9500_REG_USEMSB                           0x21
#define SX9500_REG_USELSB                           0x22
#define SX9500_REG_AVGMSB                           0x23
#define SX9500_REG_AVGLSB                           0x24
#define SX9500_REG_DIFFMSB                          0x25
#define SX9500_REG_DIFFLSB                          0x26
#define SX9500_REG_OFFSETMSB                        0x27
#define SX9500_REG_OFFSETLSB                        0x28
#define SX9500_REG_RESET                            0x7F

#define SX9500_RESET_CMD                            0xDE

typedef union {
    struct {    // sx9500 register 0x09
        uint8_t txen_stat   : 1;    // 0
        uint8_t reserved    : 2;    // 1,2
        uint8_t conv_done   : 1;    // 3
        uint8_t comp_done   : 1;    // 4
        uint8_t far         : 1;    // 5
        uint8_t close       : 1;    // 6
        uint8_t reset       : 1;    // 7
    } bits;
    uint8_t octet;
} RegIrqSrc_t;

typedef union {
    struct {    // sx9500 register 0x09
        uint8_t compstat         : 4;    // 0,1,2,3
        uint8_t proxstat0        : 1;    // 4
        uint8_t proxstat1        : 1;    // 5
        uint8_t proxstat2        : 1;    // 6
        uint8_t proxstat3        : 1;    // 7
    } bits;
    uint8_t octet;
} RegStat_t;

typedef union {
    struct {    // sx9500 register 0x06
        uint8_t sensor_en   : 4;    // 0,1,2,3
        uint8_t scan_period : 3;    // 4,5,6
        uint8_t reserved    : 1;    // 7
    } bits;
    uint8_t octet;
} RegProxCtrl0_t;

typedef union {
    struct {    // sx9500 register 0x09
        uint8_t raw_filt    : 2;    // 0,1
        uint8_t reserved    : 2;    // 2,3
        uint8_t doze_period : 2;    // 4,5
        uint8_t doze_en     : 1;    // 6
        uint8_t res7        : 1;    // 7
    } bits;
    uint8_t octet;
} RegProxCtrl3_t;

class SX9500 {
    public:
        SX9500(I2C& r, PinName en_pin, PinName nirq_pin);
        ~SX9500();
        //void try_read(void);
        uint8_t read_single(uint8_t addr);
        void read(uint8_t addr, uint8_t *dst_buf, int length);
        void write(uint8_t addr, uint8_t data);
        void reset(void);
        //uint16_t get_sensor(char CSn);
        void print_sensor(char CSn);
        void set_active(bool);
        bool get_active(void);
        void service(void);
        
        RegIrqSrc_t RegIrqSrc;
        RegProxCtrl0_t RegProxCtrl0;
        
    private:
        I2C& m_i2c;
        DigitalOut m_txen;
        DigitalIn m_nirq; // polled irq pin, because i2c is shared
};

