#include "sx9500.h"

#define SX9500_I2C_ADDRESS                          0x50    //0x28


SX9500::SX9500(I2C& r, PinName en_pin, PinName nirq_pin) : m_i2c(r), m_txen(en_pin), m_nirq(nirq_pin)
{
    m_nirq.mode(PullUp);    // no pullup on board?
    RegProxCtrl0.octet = read_single(SX9500_REG_PROXCTRL0);
}

SX9500::~SX9500()
{
}

void SX9500::reset()
{
    write(SX9500_REG_RESET, SX9500_RESET_CMD);
}

void SX9500::print_sensor(char CSn)
{
    uint8_t buf[2];
    
    write(SX9500_REG_SENSORSEL, CSn);
    
    read(SX9500_REG_USEMSB, buf, 2);
    printf("%d useful:0x%02x%02x\r\n", CSn, buf[0], buf[1]);
    
    read(SX9500_REG_AVGMSB, buf, 2);
    printf("%d   avg:0x%02x%02x\r\n", CSn, buf[0], buf[1]);
    
    read(SX9500_REG_DIFFMSB, buf, 2);
    printf("%d  diff:0x%02x%02x\r\n", CSn, buf[0], buf[1]);    
}

void SX9500::write(uint8_t addr, uint8_t data)
{
    uint8_t cmd[2];
    
    cmd[0] = addr;
    cmd[1] = data;

    if (m_i2c.write(SX9500_I2C_ADDRESS, (char *)cmd, 2))
        printf("SX9500 write-fail\n");
}

void SX9500::read(uint8_t addr, uint8_t *dst_buf, int length)
{
    char cmd[2];

    cmd[0] = addr;
    if (m_i2c.write(SX9500_I2C_ADDRESS, cmd, 1, true))
        printf("SX9500 write-fail\n");
    if (m_i2c.read(SX9500_I2C_ADDRESS, (char *)dst_buf, length))
        printf("SX9500 read-fail\n");
}

uint8_t SX9500::read_single(uint8_t addr)
{
    char cmd[2];

    cmd[0] = addr;
    if (m_i2c.write(SX9500_I2C_ADDRESS, cmd, 1, true))
        printf("SX9500 write-fail\n");
    if (m_i2c.read(SX9500_I2C_ADDRESS, cmd, 1))
        printf("SX9500 read-fail\n");

    return cmd[0];
}

bool SX9500::get_active()
{
    if (m_txen.read())
        return true;
    else
        return false;
}
    
void SX9500::set_active(bool en)
{
    if (en) {
        m_txen = 1;
    } else {
        /* lowest power (non)operation */
        m_txen = 0;
        write(SX9500_REG_PROXCTRL0, 0);  // turn off all sensor pins
    }
}

void SX9500::service()
{
    if (m_nirq.read())
        return;
        
    RegIrqSrc.octet = read_single(SX9500_REG_IRQSRC);
    printf("95irq:");
    if (RegIrqSrc.bits.conv_done) {
        printf("conv_done:\r\n");
        print_sensor(0);
        print_sensor(1);
    }
    if (RegIrqSrc.bits.comp_done) {
        printf("comp_done ");
    }
    if (RegIrqSrc.bits.far || RegIrqSrc.bits.close) {
        RegStat_t stat;
        printf("stat ");
        stat.octet = read_single(SX9500_REG_STAT);
        if (stat.bits.proxstat0)
            printf("cs0 ");
        if (stat.bits.proxstat1)
            printf("cs1 ");
    }

    if (RegIrqSrc.bits.reset) {
        printf("reset ");
    }
    
    printf("\r\n");
}

