#include "mbed.h"

/*
 * MPL3115A2 Registers
 */ 
#define STATUS_REG            0x00 // STATUS Register

#define OUT_P_MSB_REG         0x01 // Bits 12-19 of 20-bit real-time Pressure sample 
#define OUT_P_CSB_REG         0x02 // Bits 4-11 of 20-bit real-time Pressure sample 
#define OUT_P_LSB_REG         0x03 // Bits 0-3 of 20-bit real-time Pressure sample 
#define OUT_T_MSB_REG         0x04 // Bits 4-11 of 12-bit real-time Temperature sample 
#define OUT_T_LSB_REG         0x05 // Bits 0-3 of 12-bit real-time Temperature sample 

#define DR_STATUS             0x06 // Data Ready status information 

#define OUT_P_DELTA_MSB_REG   0x07 // Bits 12-19 of 20-bit Pressure change data 
#define OUT_P_DELTA_CSB_REG   0x08 // Bits 4-11 of 20-bit Pressure change data 
#define OUT_P_DELTA_LSB_REG   0x09 // Bits 0-3 of 20-bit Pressure change data 
#define OUT_T_DELTA_MSB_REG   0x0A // Bits 4-11 of 12-bit Temperature change data 
#define OUT_T_DELTA_LSB_REG   0x0B // Bits 0-3 of 12-bit Temperature change data 

#define MPL3115_ID            0x0C // Fixed Device ID Number = 0xC4 

#define F_STATUS_REG          0x0D // FIFO Status 
#define F_DATA_REG            0x0E // FIFO 8-bit data access 
#define F_SETUP_REG           0x0F // FIFO setup 
#define TIME_DLY_REG          0x10 // Time since FIFO overflow 

#define SYSMOD_REG            0x11 // Current system mode 
#define INT_SOURCE_REG        0x12 // Interrupt status 
#define PT_DATA_CFG_REG       0x13 // Data event flag configuration 

#define BAR_IN_MSB_REG        0x14 // Barometric input for Altitude calculation bits 8-15 
#define BAR_IN_LSB_REG        0x15 // Barometric input for Altitude calculation bits 0-7 

#define P_TGT_MSB_REG         0x16 // Pressure/Altitude target value bits 8-15 
#define P_TGT_LSB_REG         0x17 // Pressure/Altitude target value bits 0-7 
#define T_TGT_REG             0x18 // Temperature target value 

#define P_WND_MSB_REG         0x19 // Pressure/Altitude window value bits 8-15 
#define P_WND_LSB_REG         0x1A // Pressure/Altitude window value bits 0-7 
#define T_WND_REG             0x1B // Temperature window value 

#define P_MIN_MSB_REG         0x1C // Minimum Pressure/Altitude bits 12-19 
#define P_MIN_CSB_REG         0x1D // Minimum Pressure/Altitude bits 4-11 
#define P_MIN_LSB_REG         0x1E // Minimum Pressure/Altitude bits 0-3 
#define T_MIN_MSB_REG         0x1F // Minimum Temperature bits 8-15 
#define T_MIN_LSB_REG         0x20 // Minimum Temperature bits 0-7 

#define P_MAX_MSB_REG         0x21 // Maximum Pressure/Altitude bits 12-19 
#define P_MAX_CSB_REG         0x22 // Maximum Pressure/Altitude bits 4-11 
#define P_MAX_LSB_REG         0x23 // Maximum Pressure/Altitude bits 0-3 
#define T_MAX_MSB_REG         0x24 // Maximum Pressure/Altitude bits 8-15 
#define T_MAX_LSB_REG         0x25 // Maximum Pressure/Altitude bits 0-7 

#define CTRL_REG1             0x26 // CTRL_REG1 System Control 1 Register 
#define CTRL_REG2             0x27 // CTRL_REG2 System Control 2 Register 
#define CTRL_REG3             0x28 // CTRL_REG3 Interrupt Configuration Register 
#define CTRL_REG4             0x29 // CTRL_REG4 Interrupt Enable Register 
#define CTRL_REG5             0x2A // CTRL_REG5 Interrupt Output Pin Assignment Register 

#define OFF_P_REG             0x2B // Pressure data offset 
#define OFF_T_REG             0x2C // Temperature data offset 
#define OFF_H_REG             0x2D // Altitude data offset


typedef union { 
    struct {    // at 0x26
        uint8_t SBYB : 1;    // 0   0==standby, 1=active
        uint8_t OST  : 1;    // 1     initiate measurement now
        uint8_t RST  : 1;    // 2    software reset
        uint8_t OS   : 3;    // 3,4,5     oversampling ratio
        uint8_t RAW  : 1;    // 6          raw output mode
        uint8_t ALT  : 1;    // 7      0=barometer 1=altitude
    } bits;
    uint8_t octet;
} mpl_ctrl_reg1_t;

typedef union { 
    struct {    // at 0x
        uint8_t SRC_TCHG    : 1;    // 0
        uint8_t SRC_PCHG    : 1;    // 1
        uint8_t SRC_TTH     : 1;    // 2
        uint8_t SRC_PTH     : 1;    // 3
        uint8_t SRC_TW      : 1;    // 4
        uint8_t SRC_PW      : 1;    // 5
        uint8_t SRC_FIFO    : 1;    // 6
        uint8_t SRC_DRDY    : 1;    // 7
    } bits;
    uint8_t octet;
} mpl_int_source_t;

class MPL3115A2 {
    public:
        MPL3115A2(I2C& r, DigitalIn& int_pin);
        ~MPL3115A2();
        void write(uint8_t reg_addr, uint8_t reg_value);
        void init(void);
        uint8_t read(uint8_t a);
        void SetModeActive(void);
        bool GetModeActive(void);
        void SetModeStandby(void);
        float ReadAltitude( void ); // returns meters above sea level
        float ReadBarometer(void);  // returns pascals
        float ReadTemperature( void );  // returns celcius
        void SetModeAltimeter(void);
        void SetModeBarometer(void);
        void ToggleOneShot( void );
        void setOSR(uint8_t);
        uint8_t getOSR(void);
        float Altitude;
        float Temperature;
        void service(void);
        
        mpl_ctrl_reg1_t ctrl_reg1;

    private:
        I2C& m_i2c;
        DigitalIn& m_int_pin;
        uint8_t ctrl_reg4;
};


