#include <stdint.h>
#include <stdbool.h>
#include "device.h"
//#define DEBUG_SMBUS
#include "cmds.h"

#ifdef __cplusplus
extern "C" {
#endif

int smbus_init( PinName sda, PinName scl, uint8_t slaveAddress);

#define CBUF_SIZE        512
typedef struct {
    uint8_t cbuf[CBUF_SIZE];
    unsigned cbuf_in, cbuf_out;
    bool c_overrun;

    uint8_t tx_buf[32];
} i2c_slave_t;

extern i2c_slave_t i2c;

bool cmd_allowed(uint8_t);  // return false if slave cannot take this cmd now

void service_i2c(void);
void service_i2c_write(uint8_t cmd, uint8_t len, const uint8_t* req); // provided by application
void fill_tx_buf(uint8_t);  //provided by application

#ifdef __cplusplus
}
#endif
