#include "mbed.h"
#include "LowPowerTimeoutAbs.h"

volatile bool ev;
Timer t;

LowPowerTimeoutAbs tabs;

void my_callback()
{
    ev = true;
}

us_timestamp_t tabs_started_at;

int main()
{
    unsigned prev;
    t.start();
	tabs_started_at = tabs.read_us();
    tabs.attach_us(my_callback, tabs_started_at + 100000);
    prev = t.read_us();
	printf("tabs_started_at:%llu prev:%u\r\n", tabs_started_at, prev);
    for (;;) {
        unsigned now;
        if (ev) {
            unsigned late;
            now = t.read_us();
			tabs_started_at += 1000000;
            late = rand() % 200000;
            printf("time %u\t", now - prev);
            fflush(stdout);
            wait_us(late);
            printf("late:%u\r\n", late);
            tabs.attach_us(my_callback, tabs_started_at);
            prev = now;
            ev = false;
        }
    }
}
