#include "sx1232.h"

/* Chat application over text console via SerialPC.
 * Tested with teraterm.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

// pins for freescale freedom:
//           mosi, miso, sclk,   cs,  rst, dio0
SX1232 radio(PTD2, PTD3, PTD1, PTD0, PTD5, PTA13);

Serial pc(USBTX, USBRX);

void radio_init_user()
{    
    // default narrow-band settings
    radio.set_bitrate(4800);
    radio.set_tx_fdev_hz(5000); //   tx deviation
    radio.set_rx_dcc_bw_hz(0, 10000);  // rx bandwidth  
    radio.enable_afc(1);
    
   // pick your own frequency within your regulatory limits.
    radio.set_frf_MHz(914.1);
    
    /* radio.RegPaConfig.bits.OutputPower = X
     * radio.RegPaConfig.bits.PaSelect = 1 PA_BOOST
     * radio.write_reg(REG_PACONFIG, RegPaConfig.octet); */
}

void
service_radio()
{
    int len;

    switch (radio.service_action) {
        case SERVICE_READ_FIFO:  // this occurs when CrcOk in DIO1 pin from radio
            radio.service_action = SERVICE_NONE;
            len = radio.read_fifo();
            radio.rx_buf[len] = 0; // null terminate for printing text
            printf("%s\r\n", radio.rx_buf);
            break;
        case SERVICE_ERROR:
            radio.service_action = SERVICE_NONE;
            printf("dio0_callback() %d\r\n", radio.RegDioMapping1.bits.Dio0Mapping);
            break;
        case SERVICE_TX_DONE:
            radio.service_action = SERVICE_NONE;
            radio.start_rx();
            break;
        default: // nothing necessary to do
            break;
    } // ...switch (radio.service_action)            
}
        
int main()
{
    int txbuf_idx = 0;
    const int maxmsg = sizeof(radio.tx_buf)-1;
    
    radio_init_user();
    radio.start_rx();
    
    printf("\r\nsx1232_chat\r\n");
    while (1) {
        if (pc.readable()) {
            char c = pc.getc();
            if (c == 8 && txbuf_idx > 0) { // backspace
                pc.putc(8);
                pc.putc(' ');
                pc.putc(8);
                txbuf_idx--;
            } else if (c == '\r') {
                //radio.tx_buf[txbuf_idx] = 0; // null terminate (if printing)
                radio.start_tx(txbuf_idx);
                printf("\r\n");
                txbuf_idx = 0;
            } else if (txbuf_idx < maxmsg) {
                radio.tx_buf[txbuf_idx++] = c;
                pc.putc(c);
            }
        } else
            service_radio();
    } // ...while(1)

}
