#ifndef _TOABS_H_
#define _TOABS_H_
#include "drivers/TimerEvent.h"
#include "platform/Callback.h"
#include "platform/mbed_toolchain.h"
#include "platform/NonCopyable.h"
#include "platform/mbed_power_mgmt.h"
#include "hal/lp_ticker_api.h"
#include "platform/mbed_critical.h" 

namespace mbed {

class TimeoutAbs : public TimerEvent, private NonCopyable<TimeoutAbs> {
    public:
        TimeoutAbs() : TimerEvent(), _function(0), _lock_deepsleep(true)
        {
        }

        TimeoutAbs(const ticker_data_t* data) : TimerEvent(data), _function(0), _lock_deepsleep(true)
        {
#if DEVICE_LPTICKER
        _lock_deepsleep = (data != get_lp_ticker_data());
#endif 
        }

        virtual ~TimeoutAbs()
        {
            detach();
        }

        /** Detach the function
         */
        void detach();

    void attach_us(Callback<void()> func, us_timestamp_t t)
    {
        core_util_critical_section_enter();
        // lock only for the initial callback setup and this is not low power ticker
        if (!_function && _lock_deepsleep) {
            sleep_manager_lock_deep_sleep();
        }
        _function = func;
        abs_setup(t);
        core_util_critical_section_exit();
    }

	us_timestamp_t read_us(void)
	{
		return ticker_read_us(_ticker_data);
	}

    protected:
		void abs_setup(us_timestamp_t);
        virtual void handler();
        Callback<void()>    _function;  /**< Callback. */
        bool          _lock_deepsleep;  /**< Flag which indicates if deep sleep should be disabled. */
};

} // namespace mbed
#endif /* _TOABS_H_ */
